package com.github.gigiosouza.japigeebundler.apigee.policies.security.regexpprotection;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

import java.util.List;

@Data
@JacksonXmlRootElement(localName = "RegularExpressionProtection")
public class RegularExpressionProtectionPolicy extends Policy {

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @JacksonXmlProperty(localName = "IgnoreUnresolvedVariables")
  private Boolean ignoreUnresolvedVariables;

  @JacksonXmlElementWrapper(localName = "URIPath")
  @JacksonXmlProperty(localName = "Pattern")
  private List<String> uriPaths;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "QueryParam")
  private List<NamedPatterns> queryParams;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Header")
  private List<NamedPatterns> headers;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "FormParam")
  private List<NamedPatterns> formParams;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Variable")
  private List<NamedPatterns> variables;

  @JacksonXmlProperty(localName = "XMLPayload")
  private XMLPayload xmlPayload;

  @JacksonXmlProperty(localName = "JSONPayload")
  private JSONPayload jsonPayload;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.ignoreUnresolvedVariables = false;
  }

}
