package com.github.gigiosouza.japigeebundler.apigee.policies.security.saml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "GenerateSAMLAssertion")
public class GenerateSAMLAssertionPolicy extends Policy {

  @JacksonXmlProperty(isAttribute = true, localName = "ignoreContentType")
  private Boolean ignoreContentType;

  @JacksonXmlProperty(localName = "Issuer")
  private ValueRef<String> issuer;

  @JacksonXmlProperty(localName = "KeyStore")
  private KeyStore keyStore;

  @JacksonXmlProperty(localName = "OutputVariable")
  private OutputVariable outputVariable;

  @JacksonXmlProperty(localName = "CanonicalizationAlgorithm")
  private String canonicalizationAlgorithm;

  @JacksonXmlProperty(localName = "SignatureAlgorithm")
  private String signatureAlgorithm;

  @JacksonXmlProperty(localName = "Subject")
  private ValueRef<String> subject;

  @JacksonXmlProperty(localName = "Template")
  private Template template;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
