package com.github.gigiosouza.japigeebundler.apigee.policies.security.saml;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "ValidateSAMLAssertion")
public class ValidateSAMLAssertionPolicy extends Policy {

  @JacksonXmlProperty(localName = "Source")
  private Message source;

  @JacksonXmlProperty(localName = "TrustStore")
  private String trustStore;

  @JacksonXmlProperty(localName = "RemoveAssertion")
  private Boolean removeAssertion;

  @Override
  public void defaultValues() {
    this.defaultHeader();
  }

}
