package com.github.gigiosouza.japigeebundler.apigee.policies.security.xmlthreatprotection;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "XMLThreatProtection")
public class XMLThreatProtectionPolicy extends Policy {

  @JacksonXmlProperty(localName = "NameLimits")
  private NameLimits nameLimits;

  @JacksonXmlProperty(localName = "Source")
  private String source;

  @JacksonXmlProperty(localName = "StructuralLimits")
  private StructuralLimits structuralLimits;

  @JacksonXmlProperty(localName = "ValueLimits")
  private ValueLimits valueLimits;

  @Override
  public void defaultValues() {
    this.defaultHeader();
    this.source = "request";
  }

}
