package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.Ref;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.Collections;
import java.util.Set;

@Data
@JacksonXmlRootElement(localName = "SpikeArrest")
public class SpikeArrestPolicy extends Policy {

  @Valid
  @NotNull
  @JacksonXmlProperty(localName = "Identifier")
  private Ref identifier;

  @Valid
  @NotNull
  @JacksonXmlProperty(localName = "MessageWeight")
  private Ref messageWeight;

  @JacksonXmlProperty(localName = "Rate")
  private ValueRef<String> rate;

  @JacksonXmlProperty(localName = "UseEffectiveCount")
  private Boolean useEffectiveCount;

  public SpikeArrestPolicy() {
    this.identifier = new Ref();
    this.messageWeight = new Ref();
  }

  public void defaultValues() {
    this.defaultHeader();
    this.useEffectiveCount = false;
  }

  @Override
  protected Set<String> customValidation() {
    if (this.rate != null) {
      if (this.rate.getRef() == null || this.rate.getRef().isEmpty()) {
        if (this.rate.getValue() == null || this.rate.getValue().isEmpty()) {
          return Collections.singleton("rate.value|rate.ref: must not be null");
        } else if (!this.rate.getValue().endsWith("pm") || !this.rate.getValue().endsWith("ps")) {
          return Collections.singleton("rate.value: must end with 'ps' or 'pm'");
        }
      }
    }
    return null;
  }
}
