package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.cache;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "InvalidateCache")
public class InvalidateCachePolicy extends Policy {

  @Valid
  @NotNull
  @JacksonXmlProperty(localName = "CacheKey")
  private CacheKey cacheKey;

  @JacksonXmlProperty(localName = "CacheContext")
  private CacheContext cacheContext;

  @JacksonXmlProperty(localName = "CacheResource")
  private String cacheResource;

  @JacksonXmlProperty(localName = "PurgeChildEntries")
  private Boolean purgeChildEntries;

  @JacksonXmlProperty(localName = "Scope")
  private CacheScope scope;

  public InvalidateCachePolicy() {
    this.cacheKey = new CacheKey();
  }

  public void defaultValues() {
    this.defaultHeader();
    this.purgeChildEntries = false;
    this.scope = CacheScope.Exclusive;
  }

}
