package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.cache;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "LookupCache")
public class LookupCachePolicy extends Policy {

  @NotNull
  @JacksonXmlProperty(localName = "CacheKey")
  private CacheKey cacheKey;

  @JacksonXmlProperty(localName = "CacheResource")
  private String cacheResource;

  @JacksonXmlProperty(localName = "CacheLookupTimeoutInSeconds")
  private Integer cacheLookupTimeoutInSeconds;

  @NotNull
  @JacksonXmlProperty(localName = "AssignTo")
  private String assignTo;

  @JacksonXmlProperty(localName = "Scope")
  private CacheScope scope;

  public void defaultValues() {
    this.defaultHeader();
    this.cacheLookupTimeoutInSeconds = 30;
    this.scope = CacheScope.Exclusive;
  }

}
