package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.cache;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "PopulateCache")
public class PopulateCachePolicy extends Policy {

  @NotNull
  @JacksonXmlProperty(localName = "CacheKey")
  private CacheKey cacheKey;

  @JacksonXmlProperty(localName = "CacheResource")
  private String cacheResource;

  @JacksonXmlProperty(localName = "Scope")
  private CacheScope scope;

  @NotNull
  @JacksonXmlProperty(localName = "ExpirySettings")
  private ExpirySettings expirySettings;

  @NotNull
  @JacksonXmlProperty(localName = "Source")
  private String source;

  public PopulateCachePolicy() {
    this.cacheKey = new CacheKey();
    this.expirySettings = new ExpirySettings();
  }

  public void defaultValues() {
    this.defaultHeader();
    this.scope = CacheScope.Exclusive;
  }

}
