package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.cache;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "ResponseCache")
public class ResponseCachePolicy extends Policy {

  @NotNull
  @JacksonXmlProperty(localName = "CacheKey")
  private CacheKey cacheKey;

  @JacksonXmlProperty(localName = "Scope")
  private CacheScope scope;

  @NotNull
  @JacksonXmlProperty(localName = "ExpirySettings")
  private ExpirySettings expirySettings;

  @JacksonXmlProperty(localName = "CacheResource")
  private String cacheResource;

  @JacksonXmlProperty(localName = "CacheLookupTimeoutInSeconds")
  private Integer cacheLookupTimeoutInSeconds;

  @JacksonXmlProperty(localName = "SkipCacheLookup")
  private String skipCacheLookup;

  @JacksonXmlProperty(localName = "SkipCachePopulation")
  private String skipCachePopulation;

  @JacksonXmlProperty(localName = "UseAcceptHeader")
  private Boolean useAcceptHeader;

  @JacksonXmlProperty(localName = "UseResponseCacheHeaders")
  private Boolean useResponseCacheHeaders;

  @JacksonXmlProperty(localName = "ExcludeErrorResponse")
  private Boolean excludeErrorResponse;

  public ResponseCachePolicy() {
    this.cacheKey = new CacheKey();
    this.expirySettings = new ExpirySettings();
  }

  public void defaultValues() {
    this.defaultHeader();
    this.cacheLookupTimeoutInSeconds = 30;
    this.excludeErrorResponse = false;
    this.scope = CacheScope.Exclusive;
    this.useAcceptHeader = false;
    this.useResponseCacheHeaders = false;
  }

}
