package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.concurrentratelimit;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "ConcurrentRateLimit")
public class ConcurrentRateLimitPolicy extends Policy {

  @Valid
  @NotNull
  @JacksonXmlProperty(localName = "AllowConnections")
  private AllowConnections allowConnections;

  @JacksonXmlProperty(localName = "Distributed")
  private Boolean distributed;

  @JacksonXmlProperty(localName = "StrictOnTtl")
  private Boolean strictOnTtl;

  @Valid
  @JacksonXmlProperty(localName = "TargetIdentifier")
  private TargetIdentifier targetIdentifier;

  public ConcurrentRateLimitPolicy() {
    this.allowConnections = new AllowConnections();
  }

  public void defaultValues() {
    this.defaultHeader();
    this.distributed = false;
    this.strictOnTtl = false;
  }

}
