package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JacksonXmlRootElement(localName = "Allow")
public class AllowClass {

  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "class")
  private String quotaClass;

  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "count")
  private Integer count;

}
