package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ClassAllow {

  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "ref")
  private String ref;

  @Valid
  @JacksonXmlProperty(localName = "Allow")
  @JacksonXmlElementWrapper(useWrapping = false)
  private List<AllowClass> allows;

  public ClassAllow(final String ref) {
    this.ref = ref;
  }

}
