package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.commons.Ref;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.*;

@Data
@JacksonXmlRootElement(localName = "Quota")
public class QuotaPolicy extends Policy {

  @JacksonXmlProperty(isAttribute = true, localName = "type")
  private QuotaType type;

  @JacksonXmlProperty(localName = "Allow")
  private Allow allow;

  @NotNull
  @JacksonXmlProperty(localName = "Interval")
  private ValueRef<Integer> interval;

  @NotNull
  @JacksonXmlProperty(localName = "TimeUnit")
  private ValueRef<QuotaTimeUnit> timeUnit;

  @JacksonXmlProperty(localName = "StartTime")
  private LocalDateTime startTime;

  @JacksonXmlProperty(localName = "Distributed")
  private Boolean distributed;

  @JacksonXmlProperty(localName = "Synchronous")
  private Boolean synchronous;

  @Valid
  @JacksonXmlProperty(localName = "AsynchronousConfiguration")
  private AsynchronousConfiguration asynchronousConfiguration;

  @JacksonXmlProperty(localName = "Identifier")
  private Ref identifier;

  @JacksonXmlProperty(localName = "MessageWeight")
  private Ref messageWeight;

  public QuotaPolicy() {
    this.interval = new ValueRef<>();
    this.timeUnit = new ValueRef<>();
  }

  public void defaultValues() {
    this.defaultHeader();
    this.type = QuotaType.calendar;
    this.allow = new Allow(2000, null, null);
    this.distributed = false;
    this.synchronous = false;
    this.asynchronousConfiguration = new AsynchronousConfiguration(10, null);
  }

  @Override
  protected Set<String> customValidation() {
    if (QuotaType.calendar.equals(this.type)) {
      if (this.startTime == null) {
        return Collections.singleton("startTime: must not be null when 'type' value is 'calendar'");
      }
    }

    if (this.interval != null) {
      if (this.interval.getValue() == null && (this.interval.getRef() == null || this.interval.getRef().isEmpty())) {
        return Collections.singleton("interval.value|interval.ref: must not be null");
      }
    }
    return null;
  }

}
