package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.resetquota;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Quota {

  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @JacksonXmlProperty(isAttribute = true, localName = "ref")
  private String ref;

  @Valid
  @NotNull
  @JacksonXmlProperty(localName = "Identifier")
  private Identifier identifier;

}
