package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.resetquota;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "ResetQuota")
public class ResetQuotaPolicy extends Policy {

  @Valid
  @NotNull
  @JacksonXmlProperty(localName = "Quota")
  private Quota quota;

  public ResetQuotaPolicy() {
    this.quota = new Quota();
  }

  public void defaultValues() {
    this.defaultHeader();
  }

}
