/*
 * Decompiled with CFR 0.152.
 */
package com.github.gigiosouza.japigeebundler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.github.gigiosouza.japigeebundler.XmlMapperFactory;
import com.github.gigiosouza.japigeebundler.apigee.APIProxy;
import com.github.gigiosouza.japigeebundler.apigee.Resource;
import com.github.gigiosouza.japigeebundler.apigee.flows.proxyendpoint.ProxyEndpoint;
import com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint.TargetEndpoint;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class APIBundler {
    private APIProxy apiProxy = new APIProxy();
    private Set<ProxyEndpoint> proxyEndpoints = new HashSet<ProxyEndpoint>();
    private Set<TargetEndpoint> targetEndpoints = new HashSet<TargetEndpoint>();
    private Set<Policy> policies = new HashSet<Policy>();
    private Set<Resource> resources = new HashSet<Resource>();

    public void addProxyEndpoint(ProxyEndpoint proxyEndpoint) {
        this.proxyEndpoints.add(proxyEndpoint);
    }

    public void addTargetEndpoint(TargetEndpoint targetEndpoint) {
        this.targetEndpoints.add(targetEndpoint);
    }

    public void addPolicy(Policy policy) {
        this.policies.add(policy);
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public void bundle(String rootPath, Boolean keepSrc) throws IOException {
        XmlMapper xmlMapper = XmlMapperFactory.getInstance();
        Path bundleRoot = Paths.get(rootPath, new String[0]);
        if (!Files.exists(bundleRoot, new LinkOption[0])) {
            throw new InvalidPathException(rootPath, "Root path doesn't exist");
        }
        Path srcPath = bundleRoot.resolve(this.apiProxy.getName()).resolve("apiproxy");
        Files.createDirectories(srcPath, new FileAttribute[0]);
        if (!this.proxyEndpoints.isEmpty()) {
            Path proxiesPath = srcPath.resolve("proxies");
            Files.createDirectory(proxiesPath, new FileAttribute[0]);
            for (ProxyEndpoint proxyEndpoint : this.proxyEndpoints) {
                this.apiProxy.addProxyEndpoint(proxyEndpoint);
                Path proxyPath = Files.createFile(proxiesPath.resolve(proxyEndpoint.getName() + ".xml"), new FileAttribute[0]);
                xmlMapper.writeValue(proxyPath.toFile(), (Object)proxyEndpoint);
            }
        }
        if (!this.targetEndpoints.isEmpty()) {
            Path targetsPath = srcPath.resolve("targets");
            Files.createDirectory(targetsPath, new FileAttribute[0]);
            for (TargetEndpoint targetEndpoint : this.targetEndpoints) {
                this.apiProxy.addTargetEndpoint(targetEndpoint);
                Path targetPath = Files.createFile(targetsPath.resolve(targetEndpoint.getName() + ".xml"), new FileAttribute[0]);
                xmlMapper.writeValue(targetPath.toFile(), (Object)targetEndpoint);
            }
        }
        if (!this.policies.isEmpty()) {
            Path policiesPath = srcPath.resolve("policies");
            Files.createDirectory(policiesPath, new FileAttribute[0]);
            for (Policy policy : this.policies) {
                this.apiProxy.addPolicy(policy);
                Path policyPath = Files.createFile(policiesPath.resolve(policy.getName() + ".xml"), new FileAttribute[0]);
                xmlMapper.writeValue(policyPath.toFile(), (Object)policy);
            }
        }
        if (!this.resources.isEmpty()) {
            Path resourcesPath = srcPath.resolve("resources");
            Files.createDirectory(resourcesPath, new FileAttribute[0]);
            for (Resource resource : this.resources) {
                this.apiProxy.addResource(resource);
                Path resourcePath = resourcesPath.resolve(resource.getType().name());
                if (!Files.exists(resourcePath, new LinkOption[0])) {
                    Files.createDirectory(resourcePath, new FileAttribute[0]);
                }
                resourcePath = Files.createFile(resourcePath.resolve(resource.getFile().getName()), new FileAttribute[0]);
                xmlMapper.writeValue(resourcePath.toFile(), (Object)resource);
            }
        }
        ZonedDateTime now = ZonedDateTime.now();
        this.apiProxy.setCreatedAt(now.toEpochSecond());
        this.apiProxy.setLastModifiedAt(now.toEpochSecond());
        this.apiProxy.setCreatedBy("javaapp");
        this.apiProxy.setLastModifiedBy("javaapp");
        this.apiProxy.setDisplayName(this.apiProxy.getName());
        this.apiProxy.setDescription("my first generated api proxy bundle");
        this.apiProxy.setRevision(1);
        Path apiProxyPath = Files.createFile(srcPath.resolve(this.apiProxy.getName() + ".xml"), new FileAttribute[0]);
        xmlMapper.writeValue(apiProxyPath.toFile(), (Object)this.apiProxy);
        this.zipBundle(bundleRoot.resolve(this.apiProxy.getName() + ".zip"), srcPath.resolve("..").normalize());
        if (!keepSrc.booleanValue()) {
            this.deleteSrc(srcPath.resolve("..").normalize());
        }
    }

    private Path zipBundle(Path bundleZip, final Path srcPath) throws IOException {
        try (final ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(bundleZip.toFile());){
            Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    if (attributes.isSymbolicLink()) {
                        return FileVisitResult.CONTINUE;
                    }
                    try (FileInputStream fis = new FileInputStream(file.toFile());){
                        int len;
                        Path targetFile = srcPath.relativize(file);
                        ZipArchiveEntry zipEntry = new ZipArchiveEntry(targetFile.toString());
                        zipOut.putArchiveEntry((ArchiveEntry)zipEntry);
                        byte[] buffer = new byte[1024];
                        while ((len = fis.read(buffer)) > 0) {
                            zipOut.write(buffer, 0, len);
                        }
                        zipOut.closeArchiveEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    System.err.printf("Unable to zip : %s%n%s%n", file, exc);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return bundleZip;
    }

    private void deleteSrc(Path src) throws IOException {
        String[] children;
        if (src.toFile().isDirectory() && (children = src.toFile().list()) != null) {
            for (String child : children) {
                this.deleteSrc(src.resolve(child));
            }
        }
        Files.delete(src);
    }

    public APIProxy getApiProxy() {
        return this.apiProxy;
    }

    public Set<ProxyEndpoint> getProxyEndpoints() {
        return this.proxyEndpoints;
    }

    public Set<TargetEndpoint> getTargetEndpoints() {
        return this.targetEndpoints;
    }

    public Set<Policy> getPolicies() {
        return this.policies;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public void setApiProxy(APIProxy apiProxy) {
        this.apiProxy = apiProxy;
    }

    public void setProxyEndpoints(Set<ProxyEndpoint> proxyEndpoints) {
        this.proxyEndpoints = proxyEndpoints;
    }

    public void setTargetEndpoints(Set<TargetEndpoint> targetEndpoints) {
        this.targetEndpoints = targetEndpoints;
    }

    public void setPolicies(Set<Policy> policies) {
        this.policies = policies;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIBundler)) {
            return false;
        }
        APIBundler other = (APIBundler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        APIProxy this$apiProxy = this.getApiProxy();
        APIProxy other$apiProxy = other.getApiProxy();
        if (this$apiProxy == null ? other$apiProxy != null : !((Object)this$apiProxy).equals(other$apiProxy)) {
            return false;
        }
        Set<ProxyEndpoint> this$proxyEndpoints = this.getProxyEndpoints();
        Set<ProxyEndpoint> other$proxyEndpoints = other.getProxyEndpoints();
        if (this$proxyEndpoints == null ? other$proxyEndpoints != null : !((Object)this$proxyEndpoints).equals(other$proxyEndpoints)) {
            return false;
        }
        Set<TargetEndpoint> this$targetEndpoints = this.getTargetEndpoints();
        Set<TargetEndpoint> other$targetEndpoints = other.getTargetEndpoints();
        if (this$targetEndpoints == null ? other$targetEndpoints != null : !((Object)this$targetEndpoints).equals(other$targetEndpoints)) {
            return false;
        }
        Set<Policy> this$policies = this.getPolicies();
        Set<Policy> other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !((Object)this$policies).equals(other$policies)) {
            return false;
        }
        Set<Resource> this$resources = this.getResources();
        Set<Resource> other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof APIBundler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        APIProxy $apiProxy = this.getApiProxy();
        result = result * 59 + ($apiProxy == null ? 43 : ((Object)$apiProxy).hashCode());
        Set<ProxyEndpoint> $proxyEndpoints = this.getProxyEndpoints();
        result = result * 59 + ($proxyEndpoints == null ? 43 : ((Object)$proxyEndpoints).hashCode());
        Set<TargetEndpoint> $targetEndpoints = this.getTargetEndpoints();
        result = result * 59 + ($targetEndpoints == null ? 43 : ((Object)$targetEndpoints).hashCode());
        Set<Policy> $policies = this.getPolicies();
        result = result * 59 + ($policies == null ? 43 : ((Object)$policies).hashCode());
        Set<Resource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        return result;
    }

    public String toString() {
        return "APIBundler(apiProxy=" + this.getApiProxy() + ", proxyEndpoints=" + this.getProxyEndpoints() + ", targetEndpoints=" + this.getTargetEndpoints() + ", policies=" + this.getPolicies() + ", resources=" + this.getResources() + ")";
    }

    public APIBundler(APIProxy apiProxy, Set<ProxyEndpoint> proxyEndpoints, Set<TargetEndpoint> targetEndpoints, Set<Policy> policies, Set<Resource> resources) {
        this.apiProxy = apiProxy;
        this.proxyEndpoints = proxyEndpoints;
        this.targetEndpoints = targetEndpoints;
        this.policies = policies;
        this.resources = resources;
    }

    public APIBundler() {
    }
}

