/*
 * Decompiled with CFR 0.152.
 */
package com.github.gigiosouza.japigeebundler.apigee;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.ConfigurationVersion;
import com.github.gigiosouza.japigeebundler.apigee.Resource;
import com.github.gigiosouza.japigeebundler.apigee.flows.proxyendpoint.ProxyEndpoint;
import com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint.TargetEndpoint;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.policies.extension.FlowCalloutPolicy;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@JacksonXmlRootElement(localName="APIProxy")
public class APIProxy {
    @NotEmpty
    @NotNull
    @JacksonXmlProperty(isAttribute=true, localName="name")
    private String name;
    @NotEmpty
    @NotNull
    @JacksonXmlProperty(isAttribute=true, localName="revision")
    private Integer revision;
    @JacksonXmlProperty(localName="ConfigurationVersion")
    private ConfigurationVersion configurationVersion;
    @JacksonXmlProperty(localName="CreatedAt")
    private Long createdAt;
    @JacksonXmlProperty(localName="CreatedBy")
    private String createdBy;
    @JacksonXmlProperty(localName="LastModifiedAt")
    private Long lastModifiedAt;
    @JacksonXmlProperty(localName="LastModifiedBy")
    private String lastModifiedBy;
    @JacksonXmlProperty(localName="DisplayName")
    private String displayName;
    @JacksonXmlProperty(localName="Description")
    private String description;
    @JacksonXmlElementWrapper(localName="Basepaths")
    @JacksonXmlProperty(localName="Basepath")
    private List<String> basepaths = new ArrayList<String>();
    @JacksonXmlElementWrapper(localName="Policies")
    @JacksonXmlProperty(localName="Policy")
    private List<String> policies = new ArrayList<String>();
    @JacksonXmlElementWrapper(localName="ProxyEndpoints")
    @JacksonXmlProperty(localName="ProxyEndpoint")
    private List<String> proxyEndpoints = new ArrayList<String>();
    @JacksonXmlElementWrapper(localName="TargetEndpoints")
    @JacksonXmlProperty(localName="TargetEndpoint")
    private List<String> targetEndpoints = new ArrayList<String>();
    @JacksonXmlElementWrapper(localName="Resources")
    @JacksonXmlProperty(localName="Resource")
    private List<String> resources = new ArrayList<String>();
    @JacksonXmlElementWrapper(localName="TargetServers")
    @JacksonXmlProperty(localName="TargetServer")
    private List<String> targetServers = new ArrayList<String>();
    @JacksonXmlProperty(localName="Spec")
    private String spec;
    @JacksonXmlElementWrapper(localName="SharedFlows")
    @JacksonXmlProperty(localName="SharedFlow")
    private List<String> sharedFlows = new ArrayList<String>();

    public void defaultValues() {
        this.revision = 1;
        this.configurationVersion = new ConfigurationVersion(4, 0);
    }

    public void addProxyEndpoint(ProxyEndpoint proxyEndpoint) {
        this.proxyEndpoints.add(proxyEndpoint.getName());
        this.basepaths.add(proxyEndpoint.getHttpProxyConnection().getBasePath());
    }

    public void addTargetEndpoint(TargetEndpoint targetEndpoint) {
        this.targetEndpoints.add(targetEndpoint.getName());
        if (targetEndpoint.getHttpTargetConnection() != null && targetEndpoint.getHttpTargetConnection().getLoadBalancer() != null && targetEndpoint.getHttpTargetConnection().getLoadBalancer().getServers() != null && !targetEndpoint.getHttpTargetConnection().getLoadBalancer().getServers().isEmpty()) {
            targetEndpoint.getHttpTargetConnection().getLoadBalancer().getServers().forEach(s -> this.targetServers.add(s.getName()));
        }
    }

    public void addPolicy(Policy policy) {
        this.policies.add(policy.getName());
        if (policy instanceof FlowCalloutPolicy) {
            FlowCalloutPolicy flowCallout = (FlowCalloutPolicy)policy;
            this.sharedFlows.add(flowCallout.getSharedFlowBundle());
        }
    }

    public void addResource(Resource resource) {
        this.resources.add(resource.getType().name() + "://" + resource.getFile().getName());
    }

    public String getName() {
        return this.name;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public ConfigurationVersion getConfigurationVersion() {
        return this.configurationVersion;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getBasepaths() {
        return this.basepaths;
    }

    public List<String> getPolicies() {
        return this.policies;
    }

    public List<String> getProxyEndpoints() {
        return this.proxyEndpoints;
    }

    public List<String> getTargetEndpoints() {
        return this.targetEndpoints;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public List<String> getTargetServers() {
        return this.targetServers;
    }

    public String getSpec() {
        return this.spec;
    }

    public List<String> getSharedFlows() {
        return this.sharedFlows;
    }

    @JacksonXmlProperty(isAttribute=true, localName="name")
    public void setName(String name) {
        this.name = name;
    }

    @JacksonXmlProperty(isAttribute=true, localName="revision")
    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    @JacksonXmlProperty(localName="ConfigurationVersion")
    public void setConfigurationVersion(ConfigurationVersion configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    @JacksonXmlProperty(localName="CreatedAt")
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    @JacksonXmlProperty(localName="CreatedBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JacksonXmlProperty(localName="LastModifiedAt")
    public void setLastModifiedAt(Long lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    @JacksonXmlProperty(localName="LastModifiedBy")
    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    @JacksonXmlProperty(localName="DisplayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JacksonXmlProperty(localName="Description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JacksonXmlProperty(localName="Basepath")
    public void setBasepaths(List<String> basepaths) {
        this.basepaths = basepaths;
    }

    @JacksonXmlProperty(localName="Policy")
    public void setPolicies(List<String> policies) {
        this.policies = policies;
    }

    @JacksonXmlProperty(localName="ProxyEndpoint")
    public void setProxyEndpoints(List<String> proxyEndpoints) {
        this.proxyEndpoints = proxyEndpoints;
    }

    @JacksonXmlProperty(localName="TargetEndpoint")
    public void setTargetEndpoints(List<String> targetEndpoints) {
        this.targetEndpoints = targetEndpoints;
    }

    @JacksonXmlProperty(localName="Resource")
    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    @JacksonXmlProperty(localName="TargetServer")
    public void setTargetServers(List<String> targetServers) {
        this.targetServers = targetServers;
    }

    @JacksonXmlProperty(localName="Spec")
    public void setSpec(String spec) {
        this.spec = spec;
    }

    @JacksonXmlProperty(localName="SharedFlow")
    public void setSharedFlows(List<String> sharedFlows) {
        this.sharedFlows = sharedFlows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIProxy)) {
            return false;
        }
        APIProxy other = (APIProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$revision = this.getRevision();
        Integer other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Long this$lastModifiedAt = this.getLastModifiedAt();
        Long other$lastModifiedAt = other.getLastModifiedAt();
        if (this$lastModifiedAt == null ? other$lastModifiedAt != null : !((Object)this$lastModifiedAt).equals(other$lastModifiedAt)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ConfigurationVersion this$configurationVersion = this.getConfigurationVersion();
        ConfigurationVersion other$configurationVersion = other.getConfigurationVersion();
        if (this$configurationVersion == null ? other$configurationVersion != null : !((Object)this$configurationVersion).equals(other$configurationVersion)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$lastModifiedBy = this.getLastModifiedBy();
        String other$lastModifiedBy = other.getLastModifiedBy();
        if (this$lastModifiedBy == null ? other$lastModifiedBy != null : !this$lastModifiedBy.equals(other$lastModifiedBy)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$basepaths = this.getBasepaths();
        List<String> other$basepaths = other.getBasepaths();
        if (this$basepaths == null ? other$basepaths != null : !((Object)this$basepaths).equals(other$basepaths)) {
            return false;
        }
        List<String> this$policies = this.getPolicies();
        List<String> other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !((Object)this$policies).equals(other$policies)) {
            return false;
        }
        List<String> this$proxyEndpoints = this.getProxyEndpoints();
        List<String> other$proxyEndpoints = other.getProxyEndpoints();
        if (this$proxyEndpoints == null ? other$proxyEndpoints != null : !((Object)this$proxyEndpoints).equals(other$proxyEndpoints)) {
            return false;
        }
        List<String> this$targetEndpoints = this.getTargetEndpoints();
        List<String> other$targetEndpoints = other.getTargetEndpoints();
        if (this$targetEndpoints == null ? other$targetEndpoints != null : !((Object)this$targetEndpoints).equals(other$targetEndpoints)) {
            return false;
        }
        List<String> this$resources = this.getResources();
        List<String> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        List<String> this$targetServers = this.getTargetServers();
        List<String> other$targetServers = other.getTargetServers();
        if (this$targetServers == null ? other$targetServers != null : !((Object)this$targetServers).equals(other$targetServers)) {
            return false;
        }
        String this$spec = this.getSpec();
        String other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        List<String> this$sharedFlows = this.getSharedFlows();
        List<String> other$sharedFlows = other.getSharedFlows();
        return !(this$sharedFlows == null ? other$sharedFlows != null : !((Object)this$sharedFlows).equals(other$sharedFlows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof APIProxy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : ((Object)$revision).hashCode());
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Long $lastModifiedAt = this.getLastModifiedAt();
        result = result * 59 + ($lastModifiedAt == null ? 43 : ((Object)$lastModifiedAt).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ConfigurationVersion $configurationVersion = this.getConfigurationVersion();
        result = result * 59 + ($configurationVersion == null ? 43 : ((Object)$configurationVersion).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : $lastModifiedBy.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $basepaths = this.getBasepaths();
        result = result * 59 + ($basepaths == null ? 43 : ((Object)$basepaths).hashCode());
        List<String> $policies = this.getPolicies();
        result = result * 59 + ($policies == null ? 43 : ((Object)$policies).hashCode());
        List<String> $proxyEndpoints = this.getProxyEndpoints();
        result = result * 59 + ($proxyEndpoints == null ? 43 : ((Object)$proxyEndpoints).hashCode());
        List<String> $targetEndpoints = this.getTargetEndpoints();
        result = result * 59 + ($targetEndpoints == null ? 43 : ((Object)$targetEndpoints).hashCode());
        List<String> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        List<String> $targetServers = this.getTargetServers();
        result = result * 59 + ($targetServers == null ? 43 : ((Object)$targetServers).hashCode());
        String $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        List<String> $sharedFlows = this.getSharedFlows();
        result = result * 59 + ($sharedFlows == null ? 43 : ((Object)$sharedFlows).hashCode());
        return result;
    }

    public String toString() {
        return "APIProxy(name=" + this.getName() + ", revision=" + this.getRevision() + ", configurationVersion=" + this.getConfigurationVersion() + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ", lastModifiedAt=" + this.getLastModifiedAt() + ", lastModifiedBy=" + this.getLastModifiedBy() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", basepaths=" + this.getBasepaths() + ", policies=" + this.getPolicies() + ", proxyEndpoints=" + this.getProxyEndpoints() + ", targetEndpoints=" + this.getTargetEndpoints() + ", resources=" + this.getResources() + ", targetServers=" + this.getTargetServers() + ", spec=" + this.getSpec() + ", sharedFlows=" + this.getSharedFlows() + ")";
    }
}

