/*
 * Decompiled with CFR 0.152.
 */
package com.github.gigiosouza.japigeebundler.apigee.policies;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.Properties;
import com.github.gigiosouza.japigeebundler.apigee.exception.InvalidPolicyConfiguration;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Policy {
    @JacksonXmlProperty(isAttribute=true)
    protected Boolean async;
    @JacksonXmlProperty(isAttribute=true)
    protected Boolean continueOnError;
    @JacksonXmlProperty(isAttribute=true)
    protected Boolean enabled;
    @NotNull
    @JacksonXmlProperty(isAttribute=true)
    protected String name;
    @NotNull
    @JacksonXmlProperty(localName="DisplayName")
    protected String displayName;
    @JacksonXmlProperty(localName="Properties")
    private Properties properties;

    protected Set<String> customValidation() {
        return null;
    }

    protected void defaultHeader() {
        this.setContinueOnError(false);
        this.setEnabled(true);
        this.setAsync(false);
    }

    public abstract void defaultValues();

    public void validate(Validator validator) throws InvalidPolicyConfiguration {
        Set validatorsViolations;
        Stream<Object> violations = null;
        Set<String> customViolations = this.customValidation();
        if (customViolations != null && !customViolations.isEmpty()) {
            violations = customViolations.stream();
        }
        if (!(validatorsViolations = validator.validate((Object)this, new Class[0])).isEmpty()) {
            Stream<String> violationStream = validatorsViolations.stream().map(v -> v.getPropertyPath() + ": " + v.getMessage());
            violations = violations == null ? violationStream : Stream.concat(violations, violationStream);
        }
        if (violations != null) {
            throw new InvalidPolicyConfiguration(violations.collect(Collectors.joining("\n")));
        }
    }

    public Boolean getAsync() {
        return this.async;
    }

    public Boolean getContinueOnError() {
        return this.continueOnError;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @JacksonXmlProperty(isAttribute=true)
    public void setAsync(Boolean async) {
        this.async = async;
    }

    @JacksonXmlProperty(isAttribute=true)
    public void setContinueOnError(Boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @JacksonXmlProperty(isAttribute=true)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @JacksonXmlProperty(isAttribute=true)
    public void setName(String name) {
        this.name = name;
    }

    @JacksonXmlProperty(localName="DisplayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JacksonXmlProperty(localName="Properties")
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        Boolean this$continueOnError = this.getContinueOnError();
        Boolean other$continueOnError = other.getContinueOnError();
        if (this$continueOnError == null ? other$continueOnError != null : !((Object)this$continueOnError).equals(other$continueOnError)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Policy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        Boolean $continueOnError = this.getContinueOnError();
        result = result * 59 + ($continueOnError == null ? 43 : ((Object)$continueOnError).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "Policy(async=" + this.getAsync() + ", continueOnError=" + this.getContinueOnError() + ", enabled=" + this.getEnabled() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", properties=" + this.getProperties() + ")";
    }
}

