/*
 * Decompiled with CFR 0.152.
 */
package com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth.Attribute;
import com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth.GenerateResponse;
import com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth.OAuthGrantType;
import com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth.OAuthOperation;
import com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth.SupportedGrantTypes;
import com.github.gigiosouza.japigeebundler.apigee.policies.security.oauth.Token;
import java.util.Arrays;
import java.util.List;

@JacksonXmlRootElement(localName="OAuthV2")
public class OAuthV2Policy
extends Policy {
    @JacksonXmlProperty(localName="AccessToken")
    private String accessToken;
    @JacksonXmlProperty(localName="AccessTokenPrefix")
    private String accessTokenPrefix;
    @JacksonXmlProperty(localName="AppEndUser")
    private String appEndUser;
    @JacksonXmlElementWrapper(localName="Attributes")
    @JacksonXmlProperty(localName="Attribute")
    private List<Attribute> attributes;
    @JacksonXmlProperty(localName="ClientId")
    private String clientId;
    @JacksonXmlProperty(localName="Code")
    private String code;
    @JacksonXmlProperty(localName="ExpiresIn")
    private ValueRef<String> expiresIn;
    @JacksonXmlProperty(localName="ExternalAccessToken")
    private String externalAccessToken;
    @JacksonXmlProperty(localName="ExternalAuthorization")
    private Boolean externalAuthorization;
    @JacksonXmlProperty(localName="ExternalAuthorizationCode")
    private String externalAuthorizationCode;
    @JacksonXmlProperty(localName="ExternalRefreshToken")
    private String externalRefreshToken;
    @JacksonXmlProperty(localName="GenerateResponse")
    private GenerateResponse generateResponse;
    @JacksonXmlProperty(localName="GenerateErrorResponse")
    private GenerateResponse generateErrorResponse;
    @JacksonXmlProperty(localName="GrantType")
    private String grantType;
    @JacksonXmlProperty(localName="Operation")
    private OAuthOperation operation;
    @JacksonXmlProperty(localName="PassWord")
    private String passWord;
    @JacksonXmlProperty(localName="RedirectUri")
    private String redirectUri;
    @JacksonXmlProperty(localName="RefreshToken")
    private String refreshToken;
    @JacksonXmlProperty(localName="RefreshTokenExpiresIn")
    private ValueRef<String> refreshTokenExpiresIn;
    @JacksonXmlProperty(localName="ResponseType")
    private String responseType;
    @JacksonXmlProperty(localName="ReuseRefreshToken")
    private Boolean reuseRefreshToken;
    @JacksonXmlProperty(localName="Scope")
    private String scope;
    @JacksonXmlProperty(localName="State")
    private String state;
    @JacksonXmlProperty(localName="StoreToken")
    private Boolean storeToken;
    @JacksonXmlProperty(localName="SupportedGrantTypes")
    private SupportedGrantTypes suppertedGrantTypes;
    @JacksonXmlElementWrapper(localName="Tokens")
    @JacksonXmlProperty(localName="Token")
    private List<Token> tokens;
    @JacksonXmlProperty(localName="UserName")
    private String userName;

    @Override
    public void defaultValues() {
        this.defaultHeader();
        this.accessTokenPrefix = "Bearer";
        this.clientId = "request.formparam.client_id";
        this.code = "request.formparam.code";
        this.generateResponse = new GenerateResponse(false);
        this.generateErrorResponse = new GenerateResponse(false);
        this.grantType = "request.formparam.grant_type";
        this.passWord = "request.formparam.password";
        this.redirectUri = "request.formparam.redirect_uri";
        this.refreshToken = "request.formparam.refresh_token";
        this.responseType = "request.formparam.response_type";
        this.reuseRefreshToken = false;
        this.storeToken = false;
        this.suppertedGrantTypes = new SupportedGrantTypes(Arrays.asList(OAuthGrantType.authorization_code, OAuthGrantType.implicit));
        this.userName = "request.formparam.username";
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAccessTokenPrefix() {
        return this.accessTokenPrefix;
    }

    public String getAppEndUser() {
        return this.appEndUser;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCode() {
        return this.code;
    }

    public ValueRef<String> getExpiresIn() {
        return this.expiresIn;
    }

    public String getExternalAccessToken() {
        return this.externalAccessToken;
    }

    public Boolean getExternalAuthorization() {
        return this.externalAuthorization;
    }

    public String getExternalAuthorizationCode() {
        return this.externalAuthorizationCode;
    }

    public String getExternalRefreshToken() {
        return this.externalRefreshToken;
    }

    public GenerateResponse getGenerateResponse() {
        return this.generateResponse;
    }

    public GenerateResponse getGenerateErrorResponse() {
        return this.generateErrorResponse;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public OAuthOperation getOperation() {
        return this.operation;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public ValueRef<String> getRefreshTokenExpiresIn() {
        return this.refreshTokenExpiresIn;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public Boolean getReuseRefreshToken() {
        return this.reuseRefreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    public Boolean getStoreToken() {
        return this.storeToken;
    }

    public SupportedGrantTypes getSuppertedGrantTypes() {
        return this.suppertedGrantTypes;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public String getUserName() {
        return this.userName;
    }

    @JacksonXmlProperty(localName="AccessToken")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @JacksonXmlProperty(localName="AccessTokenPrefix")
    public void setAccessTokenPrefix(String accessTokenPrefix) {
        this.accessTokenPrefix = accessTokenPrefix;
    }

    @JacksonXmlProperty(localName="AppEndUser")
    public void setAppEndUser(String appEndUser) {
        this.appEndUser = appEndUser;
    }

    @JacksonXmlProperty(localName="Attribute")
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @JacksonXmlProperty(localName="ClientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JacksonXmlProperty(localName="Code")
    public void setCode(String code) {
        this.code = code;
    }

    @JacksonXmlProperty(localName="ExpiresIn")
    public void setExpiresIn(ValueRef<String> expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JacksonXmlProperty(localName="ExternalAccessToken")
    public void setExternalAccessToken(String externalAccessToken) {
        this.externalAccessToken = externalAccessToken;
    }

    @JacksonXmlProperty(localName="ExternalAuthorization")
    public void setExternalAuthorization(Boolean externalAuthorization) {
        this.externalAuthorization = externalAuthorization;
    }

    @JacksonXmlProperty(localName="ExternalAuthorizationCode")
    public void setExternalAuthorizationCode(String externalAuthorizationCode) {
        this.externalAuthorizationCode = externalAuthorizationCode;
    }

    @JacksonXmlProperty(localName="ExternalRefreshToken")
    public void setExternalRefreshToken(String externalRefreshToken) {
        this.externalRefreshToken = externalRefreshToken;
    }

    @JacksonXmlProperty(localName="GenerateResponse")
    public void setGenerateResponse(GenerateResponse generateResponse) {
        this.generateResponse = generateResponse;
    }

    @JacksonXmlProperty(localName="GenerateErrorResponse")
    public void setGenerateErrorResponse(GenerateResponse generateErrorResponse) {
        this.generateErrorResponse = generateErrorResponse;
    }

    @JacksonXmlProperty(localName="GrantType")
    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @JacksonXmlProperty(localName="Operation")
    public void setOperation(OAuthOperation operation) {
        this.operation = operation;
    }

    @JacksonXmlProperty(localName="PassWord")
    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    @JacksonXmlProperty(localName="RedirectUri")
    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @JacksonXmlProperty(localName="RefreshToken")
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JacksonXmlProperty(localName="RefreshTokenExpiresIn")
    public void setRefreshTokenExpiresIn(ValueRef<String> refreshTokenExpiresIn) {
        this.refreshTokenExpiresIn = refreshTokenExpiresIn;
    }

    @JacksonXmlProperty(localName="ResponseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    @JacksonXmlProperty(localName="ReuseRefreshToken")
    public void setReuseRefreshToken(Boolean reuseRefreshToken) {
        this.reuseRefreshToken = reuseRefreshToken;
    }

    @JacksonXmlProperty(localName="Scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    @JacksonXmlProperty(localName="State")
    public void setState(String state) {
        this.state = state;
    }

    @JacksonXmlProperty(localName="StoreToken")
    public void setStoreToken(Boolean storeToken) {
        this.storeToken = storeToken;
    }

    @JacksonXmlProperty(localName="SupportedGrantTypes")
    public void setSuppertedGrantTypes(SupportedGrantTypes suppertedGrantTypes) {
        this.suppertedGrantTypes = suppertedGrantTypes;
    }

    @JacksonXmlProperty(localName="Token")
    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    @JacksonXmlProperty(localName="UserName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthV2Policy)) {
            return false;
        }
        OAuthV2Policy other = (OAuthV2Policy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$externalAuthorization = this.getExternalAuthorization();
        Boolean other$externalAuthorization = other.getExternalAuthorization();
        if (this$externalAuthorization == null ? other$externalAuthorization != null : !((Object)this$externalAuthorization).equals(other$externalAuthorization)) {
            return false;
        }
        Boolean this$reuseRefreshToken = this.getReuseRefreshToken();
        Boolean other$reuseRefreshToken = other.getReuseRefreshToken();
        if (this$reuseRefreshToken == null ? other$reuseRefreshToken != null : !((Object)this$reuseRefreshToken).equals(other$reuseRefreshToken)) {
            return false;
        }
        Boolean this$storeToken = this.getStoreToken();
        Boolean other$storeToken = other.getStoreToken();
        if (this$storeToken == null ? other$storeToken != null : !((Object)this$storeToken).equals(other$storeToken)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$accessTokenPrefix = this.getAccessTokenPrefix();
        String other$accessTokenPrefix = other.getAccessTokenPrefix();
        if (this$accessTokenPrefix == null ? other$accessTokenPrefix != null : !this$accessTokenPrefix.equals(other$accessTokenPrefix)) {
            return false;
        }
        String this$appEndUser = this.getAppEndUser();
        String other$appEndUser = other.getAppEndUser();
        if (this$appEndUser == null ? other$appEndUser != null : !this$appEndUser.equals(other$appEndUser)) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        ValueRef<String> this$expiresIn = this.getExpiresIn();
        ValueRef<String> other$expiresIn = other.getExpiresIn();
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        String this$externalAccessToken = this.getExternalAccessToken();
        String other$externalAccessToken = other.getExternalAccessToken();
        if (this$externalAccessToken == null ? other$externalAccessToken != null : !this$externalAccessToken.equals(other$externalAccessToken)) {
            return false;
        }
        String this$externalAuthorizationCode = this.getExternalAuthorizationCode();
        String other$externalAuthorizationCode = other.getExternalAuthorizationCode();
        if (this$externalAuthorizationCode == null ? other$externalAuthorizationCode != null : !this$externalAuthorizationCode.equals(other$externalAuthorizationCode)) {
            return false;
        }
        String this$externalRefreshToken = this.getExternalRefreshToken();
        String other$externalRefreshToken = other.getExternalRefreshToken();
        if (this$externalRefreshToken == null ? other$externalRefreshToken != null : !this$externalRefreshToken.equals(other$externalRefreshToken)) {
            return false;
        }
        GenerateResponse this$generateResponse = this.getGenerateResponse();
        GenerateResponse other$generateResponse = other.getGenerateResponse();
        if (this$generateResponse == null ? other$generateResponse != null : !((Object)this$generateResponse).equals(other$generateResponse)) {
            return false;
        }
        GenerateResponse this$generateErrorResponse = this.getGenerateErrorResponse();
        GenerateResponse other$generateErrorResponse = other.getGenerateErrorResponse();
        if (this$generateErrorResponse == null ? other$generateErrorResponse != null : !((Object)this$generateErrorResponse).equals(other$generateErrorResponse)) {
            return false;
        }
        String this$grantType = this.getGrantType();
        String other$grantType = other.getGrantType();
        if (this$grantType == null ? other$grantType != null : !this$grantType.equals(other$grantType)) {
            return false;
        }
        OAuthOperation this$operation = this.getOperation();
        OAuthOperation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        String this$passWord = this.getPassWord();
        String other$passWord = other.getPassWord();
        if (this$passWord == null ? other$passWord != null : !this$passWord.equals(other$passWord)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        ValueRef<String> this$refreshTokenExpiresIn = this.getRefreshTokenExpiresIn();
        ValueRef<String> other$refreshTokenExpiresIn = other.getRefreshTokenExpiresIn();
        if (this$refreshTokenExpiresIn == null ? other$refreshTokenExpiresIn != null : !((Object)this$refreshTokenExpiresIn).equals(other$refreshTokenExpiresIn)) {
            return false;
        }
        String this$responseType = this.getResponseType();
        String other$responseType = other.getResponseType();
        if (this$responseType == null ? other$responseType != null : !this$responseType.equals(other$responseType)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        SupportedGrantTypes this$suppertedGrantTypes = this.getSuppertedGrantTypes();
        SupportedGrantTypes other$suppertedGrantTypes = other.getSuppertedGrantTypes();
        if (this$suppertedGrantTypes == null ? other$suppertedGrantTypes != null : !((Object)this$suppertedGrantTypes).equals(other$suppertedGrantTypes)) {
            return false;
        }
        List<Token> this$tokens = this.getTokens();
        List<Token> other$tokens = other.getTokens();
        if (this$tokens == null ? other$tokens != null : !((Object)this$tokens).equals(other$tokens)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuthV2Policy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $externalAuthorization = this.getExternalAuthorization();
        result = result * 59 + ($externalAuthorization == null ? 43 : ((Object)$externalAuthorization).hashCode());
        Boolean $reuseRefreshToken = this.getReuseRefreshToken();
        result = result * 59 + ($reuseRefreshToken == null ? 43 : ((Object)$reuseRefreshToken).hashCode());
        Boolean $storeToken = this.getStoreToken();
        result = result * 59 + ($storeToken == null ? 43 : ((Object)$storeToken).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $accessTokenPrefix = this.getAccessTokenPrefix();
        result = result * 59 + ($accessTokenPrefix == null ? 43 : $accessTokenPrefix.hashCode());
        String $appEndUser = this.getAppEndUser();
        result = result * 59 + ($appEndUser == null ? 43 : $appEndUser.hashCode());
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        ValueRef<String> $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        String $externalAccessToken = this.getExternalAccessToken();
        result = result * 59 + ($externalAccessToken == null ? 43 : $externalAccessToken.hashCode());
        String $externalAuthorizationCode = this.getExternalAuthorizationCode();
        result = result * 59 + ($externalAuthorizationCode == null ? 43 : $externalAuthorizationCode.hashCode());
        String $externalRefreshToken = this.getExternalRefreshToken();
        result = result * 59 + ($externalRefreshToken == null ? 43 : $externalRefreshToken.hashCode());
        GenerateResponse $generateResponse = this.getGenerateResponse();
        result = result * 59 + ($generateResponse == null ? 43 : ((Object)$generateResponse).hashCode());
        GenerateResponse $generateErrorResponse = this.getGenerateErrorResponse();
        result = result * 59 + ($generateErrorResponse == null ? 43 : ((Object)$generateErrorResponse).hashCode());
        String $grantType = this.getGrantType();
        result = result * 59 + ($grantType == null ? 43 : $grantType.hashCode());
        OAuthOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        String $passWord = this.getPassWord();
        result = result * 59 + ($passWord == null ? 43 : $passWord.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        ValueRef<String> $refreshTokenExpiresIn = this.getRefreshTokenExpiresIn();
        result = result * 59 + ($refreshTokenExpiresIn == null ? 43 : ((Object)$refreshTokenExpiresIn).hashCode());
        String $responseType = this.getResponseType();
        result = result * 59 + ($responseType == null ? 43 : $responseType.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        SupportedGrantTypes $suppertedGrantTypes = this.getSuppertedGrantTypes();
        result = result * 59 + ($suppertedGrantTypes == null ? 43 : ((Object)$suppertedGrantTypes).hashCode());
        List<Token> $tokens = this.getTokens();
        result = result * 59 + ($tokens == null ? 43 : ((Object)$tokens).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OAuthV2Policy(accessToken=" + this.getAccessToken() + ", accessTokenPrefix=" + this.getAccessTokenPrefix() + ", appEndUser=" + this.getAppEndUser() + ", attributes=" + this.getAttributes() + ", clientId=" + this.getClientId() + ", code=" + this.getCode() + ", expiresIn=" + this.getExpiresIn() + ", externalAccessToken=" + this.getExternalAccessToken() + ", externalAuthorization=" + this.getExternalAuthorization() + ", externalAuthorizationCode=" + this.getExternalAuthorizationCode() + ", externalRefreshToken=" + this.getExternalRefreshToken() + ", generateResponse=" + this.getGenerateResponse() + ", generateErrorResponse=" + this.getGenerateErrorResponse() + ", grantType=" + this.getGrantType() + ", operation=" + (Object)((Object)this.getOperation()) + ", passWord=" + this.getPassWord() + ", redirectUri=" + this.getRedirectUri() + ", refreshToken=" + this.getRefreshToken() + ", refreshTokenExpiresIn=" + this.getRefreshTokenExpiresIn() + ", responseType=" + this.getResponseType() + ", reuseRefreshToken=" + this.getReuseRefreshToken() + ", scope=" + this.getScope() + ", state=" + this.getState() + ", storeToken=" + this.getStoreToken() + ", suppertedGrantTypes=" + this.getSuppertedGrantTypes() + ", tokens=" + this.getTokens() + ", userName=" + this.getUserName() + ")";
    }
}

