/*
 * Decompiled with CFR 0.152.
 */
package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.commons.Ref;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Set;

@JacksonXmlRootElement(localName="SpikeArrest")
public class SpikeArrestPolicy
extends Policy {
    @Valid
    @NotNull
    @JacksonXmlProperty(localName="Identifier")
    private Ref identifier = new Ref();
    @Valid
    @NotNull
    @JacksonXmlProperty(localName="MessageWeight")
    private Ref messageWeight = new Ref();
    @JacksonXmlProperty(localName="Rate")
    private ValueRef<String> rate;
    @JacksonXmlProperty(localName="UseEffectiveCount")
    private Boolean useEffectiveCount;

    @Override
    public void defaultValues() {
        this.defaultHeader();
        this.useEffectiveCount = false;
    }

    @Override
    protected Set<String> customValidation() {
        if (this.rate != null && (this.rate.getRef() == null || this.rate.getRef().isEmpty())) {
            if (this.rate.getValue() == null || this.rate.getValue().isEmpty()) {
                return Collections.singleton("rate.value|rate.ref: must not be null");
            }
            if (!this.rate.getValue().endsWith("pm") || !this.rate.getValue().endsWith("ps")) {
                return Collections.singleton("rate.value: must end with 'ps' or 'pm'");
            }
        }
        return null;
    }

    public Ref getIdentifier() {
        return this.identifier;
    }

    public Ref getMessageWeight() {
        return this.messageWeight;
    }

    public ValueRef<String> getRate() {
        return this.rate;
    }

    public Boolean getUseEffectiveCount() {
        return this.useEffectiveCount;
    }

    @JacksonXmlProperty(localName="Identifier")
    public void setIdentifier(Ref identifier) {
        this.identifier = identifier;
    }

    @JacksonXmlProperty(localName="MessageWeight")
    public void setMessageWeight(Ref messageWeight) {
        this.messageWeight = messageWeight;
    }

    @JacksonXmlProperty(localName="Rate")
    public void setRate(ValueRef<String> rate) {
        this.rate = rate;
    }

    @JacksonXmlProperty(localName="UseEffectiveCount")
    public void setUseEffectiveCount(Boolean useEffectiveCount) {
        this.useEffectiveCount = useEffectiveCount;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpikeArrestPolicy)) {
            return false;
        }
        SpikeArrestPolicy other = (SpikeArrestPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$useEffectiveCount = this.getUseEffectiveCount();
        Boolean other$useEffectiveCount = other.getUseEffectiveCount();
        if (this$useEffectiveCount == null ? other$useEffectiveCount != null : !((Object)this$useEffectiveCount).equals(other$useEffectiveCount)) {
            return false;
        }
        Ref this$identifier = this.getIdentifier();
        Ref other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
            return false;
        }
        Ref this$messageWeight = this.getMessageWeight();
        Ref other$messageWeight = other.getMessageWeight();
        if (this$messageWeight == null ? other$messageWeight != null : !((Object)this$messageWeight).equals(other$messageWeight)) {
            return false;
        }
        ValueRef<String> this$rate = this.getRate();
        ValueRef<String> other$rate = other.getRate();
        return !(this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpikeArrestPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useEffectiveCount = this.getUseEffectiveCount();
        result = result * 59 + ($useEffectiveCount == null ? 43 : ((Object)$useEffectiveCount).hashCode());
        Ref $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        Ref $messageWeight = this.getMessageWeight();
        result = result * 59 + ($messageWeight == null ? 43 : ((Object)$messageWeight).hashCode());
        ValueRef<String> $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SpikeArrestPolicy(identifier=" + this.getIdentifier() + ", messageWeight=" + this.getMessageWeight() + ", rate=" + this.getRate() + ", useEffectiveCount=" + this.getUseEffectiveCount() + ")";
    }
}

