/*
 * Decompiled with CFR 0.152.
 */
package com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.commons.Ref;
import com.github.gigiosouza.japigeebundler.apigee.commons.ValueRef;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota.Allow;
import com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota.AsynchronousConfiguration;
import com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota.QuotaTimeUnit;
import com.github.gigiosouza.japigeebundler.apigee.policies.trafficmanagement.quota.QuotaType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Set;

@JacksonXmlRootElement(localName="Quota")
public class QuotaPolicy
extends Policy {
    @JacksonXmlProperty(isAttribute=true, localName="type")
    private QuotaType type;
    @JacksonXmlProperty(localName="Allow")
    private Allow allow;
    @NotNull
    @JacksonXmlProperty(localName="Interval")
    private ValueRef<Integer> interval = new ValueRef();
    @NotNull
    @JacksonXmlProperty(localName="TimeUnit")
    private ValueRef<QuotaTimeUnit> timeUnit = new ValueRef();
    @JacksonXmlProperty(localName="StartTime")
    private LocalDateTime startTime;
    @JacksonXmlProperty(localName="Distributed")
    private Boolean distributed;
    @JacksonXmlProperty(localName="Synchronous")
    private Boolean synchronous;
    @Valid
    @JacksonXmlProperty(localName="AsynchronousConfiguration")
    private AsynchronousConfiguration asynchronousConfiguration;
    @JacksonXmlProperty(localName="Identifier")
    private Ref identifier;
    @JacksonXmlProperty(localName="MessageWeight")
    private Ref messageWeight;

    @Override
    public void defaultValues() {
        this.defaultHeader();
        this.type = QuotaType.calendar;
        this.allow = new Allow(2000, null, null);
        this.distributed = false;
        this.synchronous = false;
        this.asynchronousConfiguration = new AsynchronousConfiguration(10, null);
    }

    @Override
    protected Set<String> customValidation() {
        if (QuotaType.calendar.equals((Object)this.type) && this.startTime == null) {
            return Collections.singleton("startTime: must not be null when 'type' value is 'calendar'");
        }
        if (this.interval != null && this.interval.getValue() == null && (this.interval.getRef() == null || this.interval.getRef().isEmpty())) {
            return Collections.singleton("interval.value|interval.ref: must not be null");
        }
        return null;
    }

    public QuotaType getType() {
        return this.type;
    }

    public Allow getAllow() {
        return this.allow;
    }

    public ValueRef<Integer> getInterval() {
        return this.interval;
    }

    public ValueRef<QuotaTimeUnit> getTimeUnit() {
        return this.timeUnit;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public Boolean getDistributed() {
        return this.distributed;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public AsynchronousConfiguration getAsynchronousConfiguration() {
        return this.asynchronousConfiguration;
    }

    public Ref getIdentifier() {
        return this.identifier;
    }

    public Ref getMessageWeight() {
        return this.messageWeight;
    }

    @JacksonXmlProperty(isAttribute=true, localName="type")
    public void setType(QuotaType type) {
        this.type = type;
    }

    @JacksonXmlProperty(localName="Allow")
    public void setAllow(Allow allow) {
        this.allow = allow;
    }

    @JacksonXmlProperty(localName="Interval")
    public void setInterval(ValueRef<Integer> interval) {
        this.interval = interval;
    }

    @JacksonXmlProperty(localName="TimeUnit")
    public void setTimeUnit(ValueRef<QuotaTimeUnit> timeUnit) {
        this.timeUnit = timeUnit;
    }

    @JacksonXmlProperty(localName="StartTime")
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @JacksonXmlProperty(localName="Distributed")
    public void setDistributed(Boolean distributed) {
        this.distributed = distributed;
    }

    @JacksonXmlProperty(localName="Synchronous")
    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    @JacksonXmlProperty(localName="AsynchronousConfiguration")
    public void setAsynchronousConfiguration(AsynchronousConfiguration asynchronousConfiguration) {
        this.asynchronousConfiguration = asynchronousConfiguration;
    }

    @JacksonXmlProperty(localName="Identifier")
    public void setIdentifier(Ref identifier) {
        this.identifier = identifier;
    }

    @JacksonXmlProperty(localName="MessageWeight")
    public void setMessageWeight(Ref messageWeight) {
        this.messageWeight = messageWeight;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotaPolicy)) {
            return false;
        }
        QuotaPolicy other = (QuotaPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$distributed = this.getDistributed();
        Boolean other$distributed = other.getDistributed();
        if (this$distributed == null ? other$distributed != null : !((Object)this$distributed).equals(other$distributed)) {
            return false;
        }
        Boolean this$synchronous = this.getSynchronous();
        Boolean other$synchronous = other.getSynchronous();
        if (this$synchronous == null ? other$synchronous != null : !((Object)this$synchronous).equals(other$synchronous)) {
            return false;
        }
        QuotaType this$type = this.getType();
        QuotaType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Allow this$allow = this.getAllow();
        Allow other$allow = other.getAllow();
        if (this$allow == null ? other$allow != null : !((Object)this$allow).equals(other$allow)) {
            return false;
        }
        ValueRef<Integer> this$interval = this.getInterval();
        ValueRef<Integer> other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        ValueRef<QuotaTimeUnit> this$timeUnit = this.getTimeUnit();
        ValueRef<QuotaTimeUnit> other$timeUnit = other.getTimeUnit();
        if (this$timeUnit == null ? other$timeUnit != null : !((Object)this$timeUnit).equals(other$timeUnit)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        AsynchronousConfiguration this$asynchronousConfiguration = this.getAsynchronousConfiguration();
        AsynchronousConfiguration other$asynchronousConfiguration = other.getAsynchronousConfiguration();
        if (this$asynchronousConfiguration == null ? other$asynchronousConfiguration != null : !((Object)this$asynchronousConfiguration).equals(other$asynchronousConfiguration)) {
            return false;
        }
        Ref this$identifier = this.getIdentifier();
        Ref other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier)) {
            return false;
        }
        Ref this$messageWeight = this.getMessageWeight();
        Ref other$messageWeight = other.getMessageWeight();
        return !(this$messageWeight == null ? other$messageWeight != null : !((Object)this$messageWeight).equals(other$messageWeight));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QuotaPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $distributed = this.getDistributed();
        result = result * 59 + ($distributed == null ? 43 : ((Object)$distributed).hashCode());
        Boolean $synchronous = this.getSynchronous();
        result = result * 59 + ($synchronous == null ? 43 : ((Object)$synchronous).hashCode());
        QuotaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Allow $allow = this.getAllow();
        result = result * 59 + ($allow == null ? 43 : ((Object)$allow).hashCode());
        ValueRef<Integer> $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        ValueRef<QuotaTimeUnit> $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)$timeUnit).hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        AsynchronousConfiguration $asynchronousConfiguration = this.getAsynchronousConfiguration();
        result = result * 59 + ($asynchronousConfiguration == null ? 43 : ((Object)$asynchronousConfiguration).hashCode());
        Ref $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        Ref $messageWeight = this.getMessageWeight();
        result = result * 59 + ($messageWeight == null ? 43 : ((Object)$messageWeight).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QuotaPolicy(type=" + (Object)((Object)this.getType()) + ", allow=" + this.getAllow() + ", interval=" + this.getInterval() + ", timeUnit=" + this.getTimeUnit() + ", startTime=" + this.getStartTime() + ", distributed=" + this.getDistributed() + ", synchronous=" + this.getSynchronous() + ", asynchronousConfiguration=" + this.getAsynchronousConfiguration() + ", identifier=" + this.getIdentifier() + ", messageWeight=" + this.getMessageWeight() + ")";
    }
}

