/*
 * Decompiled with CFR 0.152.
 */
package com.github.gino0631.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;

public final class IoStreams {
    private IoStreams() {
    }

    public static InputStream limit(InputStream is, final long limit) {
        return new DelegatingInputStream(is){
            private long available;
            private long mark;
            {
                super(is);
                this.available = limit;
                this.mark = -1L;
            }

            @Override
            public int read() throws IOException {
                int b;
                if (this.available > 0L && (b = super.read()) >= 0) {
                    --this.available;
                    return b;
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.available > 0L) {
                    len = (int)Math.min((long)len, this.available);
                    len = super.read(b, off, len);
                    this.available -= (long)len;
                    return len;
                }
                return -1;
            }

            @Override
            public long skip(long n) throws IOException {
                if ((n = Math.min(n, this.available)) > 0L) {
                    n = super.skip(n);
                    this.available -= n;
                    return n;
                }
                return 0L;
            }

            @Override
            public int available() throws IOException {
                return (int)Math.min((long)super.available(), this.available);
            }

            @Override
            public synchronized void mark(int readlimit) {
                super.mark(readlimit);
                this.mark = this.available;
            }

            @Override
            public synchronized void reset() throws IOException {
                if (this.mark < 0L) {
                    throw new IOException("Mark not set");
                }
                super.reset();
                this.available = this.mark;
            }
        };
    }

    public static InputStream count(InputStream is, final Counter counter) {
        return new DelegatingInputStream(is){
            private long mark;
            {
                super(is);
                this.mark = -1L;
            }

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b >= 0) {
                    counter.add(1L);
                }
                return b;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int n = super.read(b, off, len);
                if (n > 0) {
                    counter.add(n);
                }
                return n;
            }

            @Override
            public long skip(long n) throws IOException {
                n = super.skip(n);
                counter.add(n);
                return n;
            }

            @Override
            public synchronized void mark(int readlimit) {
                super.mark(readlimit);
                this.mark = counter.add(0L);
            }

            @Override
            public synchronized void reset() throws IOException {
                if (this.mark < 0L) {
                    throw new IOException("Mark not set");
                }
                super.reset();
                counter.add(this.mark - counter.add(0L));
            }
        };
    }

    public static OutputStream count(OutputStream os, final Counter counter) {
        return new DelegatingOutputStream(os){

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                counter.add(1L);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                counter.add(len);
            }
        };
    }

    public static InputStream closeProtect(InputStream is) {
        return new DelegatingInputStream(is){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static OutputStream closeProtect(OutputStream os) {
        return new DelegatingOutputStream(os){

            @Override
            public void close() throws IOException {
                this.flush();
            }
        };
    }

    public static void close(Closeable closeable, Consumer<IOException> errorHandler) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (errorHandler == null) break block3;
                    errorHandler.accept(e);
                }
            }
        }
    }

    public static long skip(InputStream is, long count) throws IOException {
        long remaining;
        long read;
        for (remaining = count; remaining > 0L && (read = is.skip(remaining)) > 0L; remaining -= read) {
        }
        return count - remaining;
    }

    public static long waste(InputStream is, long count) throws IOException {
        long remaining;
        long read;
        byte[] buf = new byte[(int)Math.min(count, 8192L)];
        for (remaining = count; remaining > 0L && (read = (long)is.read(buf, 0, (int)Math.min((long)buf.length, remaining))) >= 0L; remaining -= read) {
        }
        return count - remaining;
    }

    public static long exhaust(InputStream is) throws IOException {
        long read;
        long total = 0L;
        byte[] buf = new byte[8192];
        while ((read = (long)is.read(buf)) >= 0L) {
            total += read;
        }
        return total;
    }

    public static long copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    static abstract class DelegatingOutputStream
    extends OutputStream {
        private final OutputStream os;

        DelegatingOutputStream(OutputStream os) {
            this.os = os;
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
            this.os.close();
        }
    }

    static abstract class DelegatingInputStream
    extends InputStream {
        private final InputStream is;

        DelegatingInputStream(InputStream is) {
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }
    }

    @FunctionalInterface
    public static interface Counter {
        public long add(long var1);
    }
}

