/*
 * Decompiled with CFR 0.152.
 */
package com.github.gkutiel.fbi;

import com.github.gkutiel.fbi.Fbi;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class FbApp {
    private final String clientId;
    private final String clientSecret;

    public FbApp(App app) {
        this.clientId = app.appId;
        this.clientSecret = app.appSecret;
    }

    public Auth auth(String redirectUrl, Permission ... permissions) {
        return new Auth(redirectUrl, permissions);
    }

    public static class App {
        public final String appId;
        public final String appSecret;

        public App(String appId, String appSecret) {
            this.appId = appId;
            this.appSecret = appSecret;
        }
    }

    public class Auth {
        private final String redirectUri;
        private final Permission[] permissions;

        private Auth(String redirectUri, Permission ... permissions) {
            this.redirectUri = redirectUri;
            this.permissions = permissions;
        }

        public Fbi fbi(String code) throws FbLoginException {
            Preconditions.checkNotNull((Object)code);
            try {
                StringBuilder infoUrl = new StringBuilder();
                infoUrl.append("https://graph.facebook.com/oauth/access_token?client_id=");
                infoUrl.append(FbApp.this.clientId);
                infoUrl.append("&client_secret=");
                infoUrl.append(FbApp.this.clientSecret);
                infoUrl.append("&redirect_uri=");
                infoUrl.append(this.encode(this.redirectUri));
                infoUrl.append("&code=");
                infoUrl.append(code);
                String response = Fbi.get(infoUrl.toString());
                return new Fbi(this.extracteAccessToken(response));
            }
            catch (Exception e) {
                throw new FbLoginException(this.loginUrl());
            }
        }

        public String loginUrl() {
            StringBuilder loginUrl = new StringBuilder();
            loginUrl.append("https://www.facebook.com/dialog/oauth?client_id=");
            loginUrl.append(FbApp.this.clientId);
            loginUrl.append("&redirect_uri=");
            loginUrl.append(this.encode(this.redirectUri));
            loginUrl.append("&scope=");
            loginUrl.append(Joiner.on((char)',').join((Object[])this.permissions));
            return loginUrl.toString();
        }

        private String encode(String param) {
            try {
                return URLEncoder.encode(param, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private String extracteAccessToken(String response) {
            return response.replace("access_token=", "").replaceAll("&.*", "");
        }
    }

    public static class FbLoginException
    extends Exception {
        private final String loginUrl;

        public FbLoginException(String loginUrl) {
            this.loginUrl = loginUrl;
        }

        public String loginUrl() {
            return this.loginUrl;
        }

        @Override
        public String toString() {
            return "Login error, redirect to " + this.loginUrl;
        }
    }

    public static enum Permission {
        PUBLISH_STREAM("publish_stream"),
        EMAIL("email"),
        FRIENDS_BIRTHDAY("friends_birthday"),
        USER_BIRTHDAY("user_birthday"),
        USER_EVENTS("user_events");

        private String name;

        private Permission(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

