/*
 * Decompiled with CFR 0.152.
 */
package com.github.gkutiel.fbi;

import com.github.gkutiel.fbi.FbUtil;
import com.github.gkutiel.fbi.fql.FqlRes;
import com.github.gkutiel.fbi.obj.User;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

public class Fbi {
    private static final Logger LOGGER = FbUtil.getLogger(Fbi.class);
    private static final Gson GSON = new Gson();
    private static final AsyncHttpClient HTTP_CLIENT = new AsyncHttpClient();
    private static final Param PARAM_POST = new Param("method", "post");
    public final String accessToken;
    public final Param accessTokenParam;
    private User me;

    public static String get(String url) throws FbiResponseException {
        try {
            LOGGER.fine("-->\t" + url);
            String response = ((Response)HTTP_CLIENT.prepareGet(url).execute().get()).getResponseBody();
            LOGGER.fine("<--\t" + response);
            if (response.contains("\"error\"")) {
                throw new FbiResponseException(response);
            }
            return response;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Param p(String key, Object val) {
        return new Param(key, val.toString());
    }

    private static void addParam(StringBuilder url, Param p) throws UnsupportedEncodingException {
        url.append(p.key);
        url.append("=");
        url.append(URLEncoder.encode(p.val, "UTF-8"));
    }

    private static String url(String path, Param ... params) {
        try {
            StringBuilder url = new StringBuilder();
            url.append("https://graph.facebook.com/");
            url.append(path);
            if (params != null && params.length > 0) {
                url.append("?");
                Fbi.addParam(url, params[0]);
                int i = 1;
                while (i < params.length) {
                    url.append("&");
                    Fbi.addParam(url, params[i]);
                    ++i;
                }
            }
            return url.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Fbi(String accessToken) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessToken) ? 1 : 0) != 0);
        this.accessToken = accessToken;
        this.accessTokenParam = new Param("access_token", accessToken);
    }

    public <T extends FqlRes<?>> T fql(Class<T> responseClass, String query) throws FbiResponseException {
        LOGGER.fine("? " + query);
        return (T)((FqlRes)GSON.fromJson(this.fql(query), responseClass));
    }

    public String fql(String query) throws FbiResponseException {
        return Fbi.get(Fbi.url("fql", this.accessTokenParam, Fbi.p("q", query), Fbi.p("format", "json")));
    }

    public <T> T get(Class<T> c, String path, Param ... params) throws FbiResponseException {
        return (T)GSON.fromJson(this.get(path, params), c);
    }

    public String get(String path, Param ... params) throws FbiResponseException {
        return Fbi.get(Fbi.url(path, params));
    }

    public User me() throws FbiResponseException {
        if (this.me == null) {
            this.me = this.get(User.class, "/me", this.accessTokenParam, Fbi.p("fields", "id,name,picture,email"));
        }
        return this.me;
    }

    public void post(String path, Param ... params) throws FbiResponseException {
        this.get(path, (Param[])ObjectArrays.concat((Object[])params, (Object)PARAM_POST));
    }

    public void publish(Arguments<Args.Post> postArgs) throws FbiResponseException {
        this.post(String.valueOf(this.me().id) + "/feed", (Param[])ObjectArrays.concat((Object[])postArgs.get(), (Object)this.accessTokenParam));
    }

    public static interface Args {
        public String key();

        public static enum Post implements Args
        {
            MESSAGE("message"),
            PICTURE("picture"),
            LINK("link"),
            NAME("name"),
            CAPTION("caption"),
            DESCRIPTION("description"),
            SOURCE("source"),
            PLACE("place"),
            TAGS("tags");

            private final String key;

            private Post(String key) {
                this.key = key;
            }

            @Override
            public String key() {
                return this.key;
            }
        }
    }

    public static class Arguments<T extends Args> {
        private final Map<T, String> args = new HashMap<T, String>();

        public Param[] get() {
            Param[] params = new Param[this.args.size()];
            int i = 0;
            for (Map.Entry<T, String> e : this.args.entrySet()) {
                params[i++] = new Param(((Args)e.getKey()).key(), e.getValue());
            }
            return params;
        }

        public Arguments<T> set(T key, String val) {
            this.args.put(key, val);
            return this;
        }
    }

    public static class FbiResponseException
    extends Exception {
        public FbiResponseException(String response) {
            super(response);
        }
    }

    public static class Param {
        private final String key;
        private final String val;

        public Param(String key, String val) {
            this.key = key;
            this.val = val;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.val;
        }
    }
}

