/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mock;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.mock.HttpCode;
import okhttp3.mock.HttpMethod;
import okhttp3.mock.MediaTypes;
import okhttp3.mock.RuleAnswer;
import okhttp3.mock.matchers.HeaderMatcher;
import okhttp3.mock.matchers.Matcher;
import okhttp3.mock.matchers.MatcherHelper;
import okhttp3.mock.matchers.MethodMatcher;
import okhttp3.mock.matchers.NotMatcher;
import okhttp3.mock.matchers.OrMatcher;
import okhttp3.mock.matchers.PathMatcher;
import okhttp3.mock.matchers.QueryParamMatcher;
import okhttp3.mock.matchers.URLMatcher;
import okio.Buffer;
import okio.BufferedSource;

public class Rule {
    private final List<Matcher> matchers;
    private final RuleAnswer answer;
    private final long delay;
    private int times;

    private Rule(List<Matcher> matchers, RuleAnswer answer, int times, long delay) {
        this.matchers = matchers;
        this.answer = answer;
        this.times = times;
        this.delay = delay;
    }

    protected Response accept(Request request) {
        if (this.isConsumed()) {
            return null;
        }
        for (Matcher matcher : this.matchers) {
            if (matcher.matches(request)) continue;
            return null;
        }
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.times > 0 && this.times != Integer.MAX_VALUE) {
            --this.times;
        }
        return this.answer.respond(request).protocol(Protocol.HTTP_1_1).request(request).message("Rule response " + this).build();
    }

    public Map<Matcher, String> getFailReason(Request request) {
        LinkedHashMap<Matcher, String> reasons = new LinkedHashMap<Matcher, String>();
        for (Matcher matcher : this.matchers) {
            if (matcher.matches(request)) continue;
            reasons.put(matcher, matcher.failReason(request));
        }
        return reasons;
    }

    public boolean isConsumed() {
        return this.times == 0;
    }

    public String toString() {
        return this.matchers.toString() + ", consumed=" + this.isConsumed();
    }

    public static class Builder {
        private final List<Matcher> matchers = new LinkedList<Matcher>();
        private int times = 1;
        private long delay = 0L;
        private boolean negateNext;
        private boolean orNext;

        public Builder get() {
            this.method("GET");
            return this;
        }

        public Builder get(String url2) {
            this.get();
            return this.url(url2);
        }

        public Builder head() {
            this.method("HEAD");
            return this;
        }

        public Builder head(String url2) {
            this.head();
            return this.url(url2);
        }

        public Builder post() {
            this.method("POST");
            return this;
        }

        public Builder post(String url2) {
            this.post();
            return this.url(url2);
        }

        public Builder put() {
            this.method("PUT");
            return this;
        }

        public Builder put(String url2) {
            this.put();
            return this.url(url2);
        }

        public Builder delete() {
            this.method("DELETE");
            return this;
        }

        public Builder delete(String url2) {
            this.delete();
            return this.url(url2);
        }

        public Builder options() {
            this.method("OPTIONS");
            return this;
        }

        public Builder options(String url2) {
            this.options();
            return this.url(url2);
        }

        public Builder patch() {
            this.method("PATCH");
            return this;
        }

        public Builder patch(String url2) {
            this.patch();
            return this.url(url2);
        }

        public Builder method(@HttpMethod String method) {
            this.matches(new MethodMatcher(method));
            return this;
        }

        public Builder url(String url2) {
            this.urlMatches(MatcherHelper.exact(url2));
            return this;
        }

        public Builder urlStarts(String prefix) {
            this.urlMatches(MatcherHelper.prefix(prefix));
            return this;
        }

        public Builder urlEnds(String suffix) {
            this.urlMatches(MatcherHelper.suffix(suffix));
            return this;
        }

        public Builder urlMatches(Pattern pattern) {
            this.matches(new URLMatcher(pattern));
            return this;
        }

        public Builder path(String path2) {
            this.pathMatches(MatcherHelper.exact(path2));
            return this;
        }

        public Builder pathStarts(String prefix) {
            this.pathMatches(MatcherHelper.prefix(prefix));
            return this;
        }

        public Builder pathEnds(String suffix) {
            this.pathMatches(MatcherHelper.suffix(suffix));
            return this;
        }

        public Builder pathMatches(Pattern pattern) {
            this.matches(new PathMatcher(pattern));
            return this;
        }

        public Builder hasHeader(String header2) {
            this.headerMatches(header2, MatcherHelper.any());
            return this;
        }

        public Builder header(String header2, String value) {
            this.headerMatches(header2, MatcherHelper.exact(value));
            return this;
        }

        public Builder headerMatches(String header2, Pattern pattern) {
            this.matches(new HeaderMatcher(header2, pattern));
            return this;
        }

        public Builder paramMatches(String param2, Pattern pattern) {
            this.matches(new QueryParamMatcher(param2, pattern));
            return this;
        }

        public Builder hasParam(String param2) {
            this.paramMatches(param2, MatcherHelper.any());
            return this;
        }

        public Builder param(String param2, String value) {
            this.paramMatches(param2, MatcherHelper.exact(value));
            return this;
        }

        public Builder not() {
            if (this.negateNext) {
                throw new IllegalStateException("'not()' can't be followed by another 'not()'");
            }
            this.negateNext = true;
            return this;
        }

        public Builder or() {
            if (this.orNext) {
                throw new IllegalStateException("'or()' can't be followed by another 'or()'");
            }
            this.orNext = true;
            return this;
        }

        public Builder matches(Matcher matcher) {
            if (this.negateNext) {
                this.negateNext = false;
                matcher = new NotMatcher(matcher);
            }
            if (this.orNext) {
                int count = this.matchers.size();
                if (count <= 0) {
                    throw new IllegalStateException("'or()' can't be the first matcher!");
                }
                this.orNext = false;
                Matcher prev = this.matchers.remove(count - 1);
                if (prev instanceof OrMatcher) {
                    ((OrMatcher)prev).add(matcher);
                    matcher = prev;
                } else {
                    matcher = new OrMatcher(prev, matcher);
                }
            }
            this.matchers.add(matcher);
            return this;
        }

        public Builder times(int times) {
            this.times = times;
            return this;
        }

        public Builder anyTimes() {
            this.times = Integer.MAX_VALUE;
            return this;
        }

        public Builder delay(long milliseconds) {
            this.delay = milliseconds;
            return this;
        }

        public Response.Builder respond(@NonNull String body) {
            return this.respond(body, MediaTypes.MEDIATYPE_TEXT);
        }

        public Response.Builder respond(@NonNull String body, @NonNull MediaType mediaType) {
            return this.respond(ResponseBody.create((MediaType)mediaType, (String)body));
        }

        public Response.Builder respond(@NonNull byte[] body) {
            return this.respond(body, MediaTypes.MEDIATYPE_RAW_DATA);
        }

        public Response.Builder respond(@NonNull byte[] body, @NonNull MediaType mediaType) {
            return this.respond(ResponseBody.create((MediaType)mediaType, (byte[])body));
        }

        public Response.Builder respond(@NonNull InputStream body) {
            return this.respond(-1L, body);
        }

        public Response.Builder respond(@NonNull InputStream body, @NonNull MediaType mediaType) {
            return this.respond(-1L, body, mediaType);
        }

        public Response.Builder respond(long contentLength, @NonNull InputStream body) {
            return this.respond(contentLength, body, MediaTypes.MEDIATYPE_RAW_DATA);
        }

        public Response.Builder respond(long contentLength, @NonNull InputStream body, @NonNull MediaType mediaType) {
            try {
                return this.respond(ResponseBody.create((MediaType)mediaType, (long)contentLength, (BufferedSource)new Buffer().readFrom(body)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Response.Builder respond(@HttpCode int code) {
            return this.respond(code, (ResponseBody)null);
        }

        public Response.Builder respond(@Nullable ResponseBody body) {
            return this.respond(200, body);
        }

        public Response.Builder respond(@HttpCode int code, @Nullable ResponseBody body) {
            FinalRuleBuilder builder = new FinalRuleBuilder();
            builder.code(code);
            builder.body(body != null ? body : ResponseBody.create(null, (String)""));
            this.onBuild(builder.buildRule());
            return builder;
        }

        public void answer(RuleAnswer answer) {
            this.onBuild(new Rule(Collections.unmodifiableList(this.matchers), answer, this.times, this.delay));
        }

        void onBuild(Rule rule) {
        }

        class FinalRuleBuilder
        extends Response.Builder
        implements RuleAnswer {
            private final boolean repeteable;
            private ResponseBody repeteableBody;
            private byte[] repeteableBodyContent;

            FinalRuleBuilder() {
                this.repeteable = Builder.this.times != 1;
            }

            Rule buildRule() {
                if (Builder.this.negateNext) {
                    throw new IllegalStateException("Misted a predicate after 'not()'!");
                }
                if (Builder.this.orNext) {
                    throw new IllegalStateException("Misted a predicate after 'or()'!");
                }
                if (Builder.this.times < 1) {
                    throw new IllegalStateException("Time can't be less than 1!");
                }
                if (Builder.this.delay < 0L) {
                    throw new IllegalStateException("Delay can't be less than 0!");
                }
                return new Rule(Collections.unmodifiableList(Builder.this.matchers), this, Builder.this.times, Builder.this.delay);
            }

            public Response.Builder body(ResponseBody body) {
                if (this.repeteable) {
                    this.repeteableBody = body;
                    try {
                        this.repeteableBodyContent = body.bytes();
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("error preloading body for rule " + this, e);
                    }
                }
                return super.body(body);
            }

            @Override
            public Response.Builder respond(Request request) {
                if (this.repeteable) {
                    Buffer buffer = this.repeteableBody.source().buffer();
                    buffer.clear();
                    buffer.write(this.repeteableBodyContent);
                }
                return this;
            }
        }
    }
}

