/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mock.matchers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function0;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.mock.Rules;
import okhttp3.mock.matchers.PatternMatcher;
import okio.Buffer;
import okio.BufferedSink;

public class BodyMatcher
extends PatternMatcher {
    private final Charset charset;

    public BodyMatcher(Pattern pattern) {
        this(pattern, null);
    }

    public BodyMatcher(Pattern pattern, Charset charset) {
        super(pattern);
        this.charset = charset != null ? charset : StandardCharsets.UTF_8;
    }

    @Override
    protected String getText(Request request) {
        RequestBody body2 = request.body();
        Rules.assertThat(body2 != null, (Function0<? extends Object>)((Function0)() -> "Request" + request + " does not have a body"));
        assert (body2 != null);
        Rules.assertThat(!body2.isDuplex(), (Function0<? extends Object>)((Function0)() -> "duplex bodies can't be matched"));
        Rules.assertThat(!body2.isOneShot(), (Function0<? extends Object>)((Function0)() -> "onShoot bodies can't be matched"));
        try {
            Buffer buffer = new Buffer();
            body2.writeTo((BufferedSink)buffer);
            return buffer.readString(this.charset);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read body of request: " + request, e);
        }
    }

    public String toString() {
        return "requestBody(" + this.pattern.pattern() + "); charset=" + this.charset;
    }
}

