/*
 * Decompiled with CFR 0.152.
 */
package com.github.goive.steamapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.goive.steamapi.data.SteamApp;
import com.github.goive.steamapi.data.SteamAppBuilder;
import com.github.goive.steamapi.data.SteamId;
import com.github.goive.steamapi.exceptions.SteamApiException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SteamApi {
    private static final String APP_ID_LIST_URL = "http://api.steampowered.com/ISteamApps/GetAppList/v0001/";
    private static final String API_URL = "http://store.steampowered.com/api/appdetails?appids=";
    private ObjectMapper mapper = new ObjectMapper();
    private String countryCode;

    public SteamApi() {
        this(Locale.getDefault().getCountry());
    }

    public SteamApi(String countryCode) {
        this.setCountryCode(countryCode);
    }

    public SteamApp retrieve(SteamId app) throws SteamApiException {
        Map resultBodyMap;
        String appId = app.getAppId();
        try {
            URL src = new URL(API_URL + appId + "&cc=" + this.countryCode);
            resultBodyMap = (Map)this.mapper.readValue(src, Map.class);
        }
        catch (IOException e) {
            throw new SteamApiException(e);
        }
        if (!this.successfullyRetrieved(resultBodyMap, appId)) {
            throw new SteamApiException("Invalid appId given: " + appId);
        }
        return new SteamAppBuilder().withResultMap(resultBodyMap).build();
    }

    private boolean successfullyRetrieved(Map resultBodyMap, String appId) {
        return (Boolean)((Map)resultBodyMap.get(String.valueOf(appId))).get("success");
    }

    public List<SteamId> listIds() throws SteamApiException {
        Map resultMap;
        try {
            URL src = new URL(APP_ID_LIST_URL);
            resultMap = (Map)this.mapper.readValue(src, Map.class);
        }
        catch (IOException e) {
            throw new SteamApiException("Error fetching list of valid AppIDs.", e);
        }
        Map appMap = (Map)resultMap.get("applist");
        Map apps = (Map)appMap.get("apps");
        List appList = (List)apps.get("app");
        ArrayList<SteamId> result = new ArrayList<SteamId>();
        for (Object app : appList) {
            Map appItem = (Map)app;
            result.add(SteamId.create(appItem.get("appid").toString(), appItem.get("name").toString()));
        }
        return result;
    }

    public void setCountryCode(String countryCode) {
        if (StringUtils.isBlank((CharSequence)countryCode)) {
            throw new IllegalArgumentException("Country code cannot be empty.");
        }
        this.countryCode = countryCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }
}

