/*
 * Decompiled with CFR 0.152.
 */
package com.github.goive.steamapi.data;

import com.github.goive.steamapi.data.Price;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class SteamApp
implements Comparable<SteamApp> {
    private final long appId;
    private final String type;
    private final String name;
    private final int requiredAge;
    private final String detailedDescription;
    private final String aboutTheGame;
    private final List<String> supportedLanguages;
    private final String headerImage;
    private final String website;
    private final Price price;
    private final List<String> developers;
    private final List<String> publishers;
    private final boolean availableForLinux;
    private final boolean availableForWindows;
    private final boolean availableForMac;
    private final List<String> categories;
    private final Date releaseDate;
    private final Integer metacriticScore;
    private final String metacriticUrl;
    private final String supportUrl;
    private final String supportEmail;

    SteamApp(long appId, String type, String name, int requiredAge, String detailedDescription, String aboutTheGame, List<String> supportedLanguages, String headerImage, String website, Price price, List<String> developers, List<String> publishers, boolean availableForLinux, boolean availableForWindows, boolean availableForMac, List<String> categories, Date releaseDate, Integer metacriticScore, String metacriticUrl, String supportUrl, String supportEmail) {
        this.appId = appId;
        this.type = type;
        this.name = name;
        this.requiredAge = requiredAge;
        this.detailedDescription = detailedDescription;
        this.aboutTheGame = aboutTheGame;
        this.supportedLanguages = supportedLanguages;
        this.headerImage = headerImage;
        this.website = website;
        this.price = price;
        this.developers = developers;
        this.publishers = publishers;
        this.availableForLinux = availableForLinux;
        this.availableForWindows = availableForWindows;
        this.availableForMac = availableForMac;
        this.categories = categories;
        this.releaseDate = releaseDate;
        this.metacriticScore = metacriticScore;
        this.metacriticUrl = metacriticUrl;
        this.supportUrl = supportUrl;
        this.supportEmail = supportEmail;
    }

    public long getAppId() {
        return this.appId;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getRequiredAge() {
        return this.requiredAge;
    }

    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public String getAboutTheGame() {
        return this.aboutTheGame;
    }

    public List<String> getSupportedLanguages() {
        return Collections.unmodifiableList(this.supportedLanguages);
    }

    public String getHeaderImage() {
        return this.headerImage;
    }

    public String getWebsite() {
        return this.website;
    }

    public List<String> getDevelopers() {
        return Collections.unmodifiableList(this.developers);
    }

    public List<String> getPublishers() {
        return Collections.unmodifiableList(this.publishers);
    }

    public boolean isAvailableForLinux() {
        return this.availableForLinux;
    }

    public boolean isAvailableForWindows() {
        return this.availableForWindows;
    }

    public boolean isAvailableForMac() {
        return this.availableForMac;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public Integer getMetacriticScore() {
        return this.metacriticScore;
    }

    public String getMetacriticUrl() {
        return this.metacriticUrl;
    }

    public Price getPrice() {
        return this.price;
    }

    public List<String> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }

    public String getSupportEmail() {
        return this.supportEmail;
    }

    public boolean isFreeToPlay() {
        if (this.price == null) {
            return true;
        }
        return this.price.getFinalPrice().compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean isDiscounted() {
        return this.isDiscountedByAtLeast(1);
    }

    public boolean isDiscountedByAtLeast(int percent) {
        if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("Percentage must be between 0 and 100");
        }
        if (this.price == null) {
            return false;
        }
        return this.price.getDiscountPercent() >= percent;
    }

    public boolean isInAnyCategory(String ... categories) {
        if (this.categories == null) {
            return false;
        }
        for (String category : categories) {
            if (!this.categories.contains(category)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.appId).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SteamApp)) {
            return false;
        }
        SteamApp other = (SteamApp)obj;
        return new EqualsBuilder().append(this.appId, other.appId).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this.appId).append((Object)this.type).append((Object)this.name).append(this.requiredAge).append((Object)this.detailedDescription).append((Object)this.aboutTheGame).append(this.supportedLanguages).append((Object)this.headerImage).append((Object)this.website).append((Object)this.price).append(this.developers).append(this.publishers).append(this.availableForLinux).append(this.availableForWindows).append(this.availableForMac).append(this.categories).append((Object)this.releaseDate).append((Object)this.metacriticScore).append((Object)this.metacriticUrl).append((Object)this.supportUrl).append((Object)this.supportEmail).toString();
    }

    @Override
    public int compareTo(SteamApp other) {
        return (int)(this.appId - other.appId);
    }
}

