/*
 * Decompiled with CFR 0.152.
 */
package com.github.goive.steamapi.data;

import com.github.goive.steamapi.data.Price;
import com.github.goive.steamapi.data.SteamApp;
import com.github.goive.steamapi.exceptions.SteamApiException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SteamAppBuilder {
    private static final Logger logger = Logger.getLogger(SteamAppBuilder.class);
    private static final String MAC = "mac";
    private static final String LINUX = "linux";
    private static final String WINDOWS = "windows";
    private static final String PLATFORMS = "platforms";
    private static final String PUBLISHERS = "publishers";
    private static final String DEVELOPERS = "developers";
    private static final String PRICE_OVERVIEW = "price_overview";
    private static final String CURRENCY = "currency";
    private static final String INITIAL = "initial";
    private static final String FINAL = "final";
    private static final String DISCOUNT_PERCENT = "discount_percent";
    private static final String DATE = "date";
    private static final String RELEASE_DATE = "release_date";
    private static final String DESCRIPTION = "description";
    private static final String CATEGORIES = "categories";
    private static final String SCORE = "score";
    private static final String METACRITIC = "metacritic";
    private static final String EMAIL = "email";
    private static final String URL = "url";
    private static final String SUPPORT_INFO = "support_info";
    private static final String WEBSITE = "website";
    private static final String HEADER_IMAGE = "header_image";
    private static final String SUPPORTED_LANGUAGES = "supported_languages";
    private static final String ABOUT_THE_GAME = "about_the_game";
    private static final String DETAILED_DESCRIPTION = "detailed_description";
    private static final String REQUIRED_AGE = "required_age";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String DATA = "data";
    private static final String UNCHECKED = "unchecked";
    private long appId;
    private String type;
    private String name;
    private int requiredAge;
    private String detailedDescription;
    private String aboutTheGame;
    private List<String> supportedLanguages;
    private String headerImage;
    private String website;
    private Price price;
    private List<String> developers;
    private List<String> publishers;
    private boolean availableForLinux;
    private boolean availableForWindows;
    private boolean availableForMac;
    private List<String> categories;
    private Date releaseDate;
    private Integer metacriticScore;
    private String metacriticUrl;
    private String supportUrl;
    private String supportEmail;

    public SteamAppBuilder withResultMap(Map<Object, Object> resultMap) throws SteamApiException {
        Set<Object> keySet = resultMap.keySet();
        for (Object key : keySet) {
            this.appId = Long.parseLong((String)key);
            this.fillFields(resultMap);
        }
        return this;
    }

    private void fillFields(Map<Object, Object> resultMap) throws SteamApiException {
        Map innerMap = (Map)resultMap.get(this.appId + "");
        if (!((Boolean)innerMap.get("success")).booleanValue()) {
            throw new SteamApiException("Invalid appId: " + this.appId, null);
        }
        Map dataMap = (Map)innerMap.get(DATA);
        this.parseGenericData(dataMap);
        this.parsePriceData(dataMap);
        this.parseMarketData(dataMap);
        this.parsePlatformData(dataMap);
        this.parseCategoriesData(dataMap);
        this.parseReleaseDate(dataMap);
        this.parseMetacriticData(dataMap);
        this.parseSupportInfo(dataMap);
    }

    private void parseGenericData(Map<Object, Object> dataMap) {
        this.type = (String)dataMap.get(TYPE);
        this.name = (String)dataMap.get(NAME);
        try {
            this.requiredAge = (Integer)dataMap.get(REQUIRED_AGE);
        }
        catch (ClassCastException e) {
            logger.debug((Object)("Could not parse required age for appId " + this.appId + " as integer. Trying string..."), (Throwable)e);
            this.requiredAge = Integer.valueOf((String)dataMap.get(REQUIRED_AGE));
        }
        this.detailedDescription = (String)dataMap.get(DETAILED_DESCRIPTION);
        this.aboutTheGame = (String)dataMap.get(ABOUT_THE_GAME);
        String supportedLanguagesRaw = (String)dataMap.get(SUPPORTED_LANGUAGES);
        if (supportedLanguagesRaw != null) {
            this.supportedLanguages = Arrays.asList(supportedLanguagesRaw.split("\\s*,\\s*"));
        }
        this.headerImage = (String)dataMap.get(HEADER_IMAGE);
        this.website = (String)dataMap.get(WEBSITE);
    }

    private void parsePriceData(Map<Object, Object> dataMap) {
        Map priceOverview = (Map)dataMap.get(PRICE_OVERVIEW);
        if (priceOverview == null) {
            logger.info((Object)("No price data found. Assuming " + this.name + " is free to play."));
            return;
        }
        this.price = new Price(Currency.getInstance((String)priceOverview.get(CURRENCY)), new BigDecimal(String.valueOf(priceOverview.get(INITIAL))).divide(new BigDecimal(100)), new BigDecimal(String.valueOf(priceOverview.get(FINAL))).divide(new BigDecimal(100)), (Integer)priceOverview.get(DISCOUNT_PERCENT));
    }

    private void parseMarketData(Map<Object, Object> dataMap) {
        this.developers = (List)dataMap.get(DEVELOPERS);
        this.publishers = (List)dataMap.get(PUBLISHERS);
    }

    private void parsePlatformData(Map<Object, Object> dataMap) {
        Map platformsMap = (Map)dataMap.get(PLATFORMS);
        this.availableForLinux = (Boolean)platformsMap.get(LINUX);
        this.availableForMac = (Boolean)platformsMap.get(MAC);
        this.availableForWindows = (Boolean)platformsMap.get(WINDOWS);
    }

    private void parseCategoriesData(Map<Object, Object> dataMap) {
        this.categories = new ArrayList<String>();
        List categoriesMap = (List)dataMap.get(CATEGORIES);
        if (categoriesMap == null) {
            logger.info((Object)("No categories data found for " + this.appId + " - " + this.name));
            return;
        }
        for (Object categoryObject : categoriesMap) {
            Map categoryItemMap = (Map)categoryObject;
            String description = (String)categoryItemMap.get(DESCRIPTION);
            this.categories.add(description);
        }
    }

    private void parseReleaseDate(Map<Object, Object> dataMap) {
        Map releaseMap = (Map)dataMap.get(RELEASE_DATE);
        String dateString = (String)releaseMap.get(DATE);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM, yyyy", Locale.US);
            this.releaseDate = simpleDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            logger.warn((Object)("Could not parse release date for appId " + this.appId), (Throwable)e);
        }
    }

    private void parseMetacriticData(Map<Object, Object> dataMap) {
        Map metacriticMap = (Map)dataMap.get(METACRITIC);
        if (metacriticMap == null) {
            logger.info((Object)("No metacritic data found for " + this.appId + " - " + this.name));
            return;
        }
        this.metacriticScore = (Integer)metacriticMap.get(SCORE);
        this.metacriticUrl = (String)metacriticMap.get(URL);
    }

    private void parseSupportInfo(Map<Object, Object> dataMap) {
        Map supportInfoMap = (Map)dataMap.get(SUPPORT_INFO);
        this.supportUrl = (String)supportInfoMap.get(URL);
        this.supportEmail = (String)supportInfoMap.get(EMAIL);
    }

    public SteamApp build() {
        return new SteamApp(this.appId, this.type, this.name, this.requiredAge, this.detailedDescription, this.aboutTheGame, this.supportedLanguages, this.headerImage, this.website, this.price, this.developers, this.publishers, this.availableForLinux, this.availableForWindows, this.availableForMac, this.categories, this.releaseDate, this.metacriticScore, this.metacriticUrl, this.supportUrl, this.supportEmail);
    }
}

