/*
 * Decompiled with CFR 0.152.
 */
package com.github.goive.steamapi.data;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SteamId {
    private String appId;
    private String appName;

    public static SteamId create(String appId) {
        return new SteamId(appId, "Unnamed Application");
    }

    public static SteamId create(long appId) {
        return new SteamId(Long.toString(appId), "Unnamed Application");
    }

    public static SteamId create(String appId, String appName) {
        return new SteamId(appId, appName);
    }

    private SteamId(String appId, String appName) {
        this.appId = appId;
        this.appName = appName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SteamId steamId = (SteamId)o;
        return new EqualsBuilder().append((Object)this.appId, (Object)steamId.appId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.appId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("appId", (Object)this.appId).append("appName", (Object)this.appName).toString();
    }
}

