package com.github.gobars.id.worker;

import com.github.gobars.id.WorkerId;
import com.github.gobars.id.util.Files;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.List;

/**
 * WorkerId组合器
 *
 * <p>组合多个WorkerID的实现，然后按顺序获取可用worker ID
 */
@Slf4j
public class WorkerIdComposite implements WorkerId {
  private final List<WorkerId> workerIds;

  public WorkerIdComposite(List<WorkerId> workerIds) {
    this.workerIds = workerIds;
  }

  public WorkerIdComposite(WorkerId... workerIds) {
    this(Arrays.asList(workerIds));
  }

  @Override
  public int workerId() {
    for (WorkerId workerId : workerIds) {
      int v = workerId.workerId();
      if (v > 0) {
        log.info("a worker id {} generated by {}, check its availability", v, workerId.getClass());

        v = Files.findAvailableWorkerID(v, true);
      }

      if (v > 0) {
        log.info("a worker id {} generated by {}", v, workerId.getClass());

        return v;
      }
    }

    return 0;
  }
}
