/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.conf;

import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Base {
    private static final Logger log = LoggerFactory.getLogger(Base.class);
    private final long epoch;
    private final int timestampBits;
    private final int roundMs;
    private final int backwardBits;
    private final int workerBits;
    private final int seqBits;
    private final long maxBackwardSleepMs;
    private final String timestampBy;

    public static Base fromSpec(String spec) {
        String[] items;
        BaseBuilder builder = Base.builder();
        for (String item : items = spec.split(",")) {
            if ((item = item.trim()).length() == 0) continue;
            String[] parts = item.split("=", 2);
            String key = parts[0];
            String val = parts[1];
            if (key.equals("epoch")) {
                long epoch = new SimpleDateFormat("yyyyMMdd").parse(val).getTime();
                builder.epoch(epoch);
                continue;
            }
            if (key.equals("timestampBits")) {
                builder.timestampBits(Integer.parseInt(val));
                continue;
            }
            if (key.equals("roundMs")) {
                builder.roundMs(Integer.parseInt(val));
                continue;
            }
            if (key.equals("backwardBits")) {
                builder.backwardBits(Integer.parseInt(val));
                continue;
            }
            if (key.equals("workerBits")) {
                builder.workerBits(Integer.parseInt(val));
                continue;
            }
            if (key.equals("seqBits")) {
                builder.seqBits(Integer.parseInt(val));
                continue;
            }
            if (key.equals("maxBackwardSleepMs")) {
                builder.maxBackwardSleepMs(Integer.parseInt(val));
                continue;
            }
            if (!key.equals("timestampBy")) continue;
            builder.timestampBy(val);
        }
        Base base = builder.build();
        log.info("base built {} from spec {}", (Object)base, (Object)spec);
        return base;
    }

    private static long $default$epoch() {
        return 1591113600000L;
    }

    private static int $default$timestampBits() {
        return 41;
    }

    private static int $default$roundMs() {
        return 1;
    }

    private static int $default$backwardBits() {
        return 0;
    }

    private static int $default$workerBits() {
        return 10;
    }

    private static int $default$seqBits() {
        return 12;
    }

    private static long $default$maxBackwardSleepMs() {
        return 1000L;
    }

    private static String $default$timestampBy() {
        return "cache";
    }

    Base(long epoch, int timestampBits, int roundMs, int backwardBits, int workerBits, int seqBits, long maxBackwardSleepMs, String timestampBy) {
        this.epoch = epoch;
        this.timestampBits = timestampBits;
        this.roundMs = roundMs;
        this.backwardBits = backwardBits;
        this.workerBits = workerBits;
        this.seqBits = seqBits;
        this.maxBackwardSleepMs = maxBackwardSleepMs;
        this.timestampBy = timestampBy;
    }

    public static BaseBuilder builder() {
        return new BaseBuilder();
    }

    public long getEpoch() {
        return this.epoch;
    }

    public int getTimestampBits() {
        return this.timestampBits;
    }

    public int getRoundMs() {
        return this.roundMs;
    }

    public int getBackwardBits() {
        return this.backwardBits;
    }

    public int getWorkerBits() {
        return this.workerBits;
    }

    public int getSeqBits() {
        return this.seqBits;
    }

    public long getMaxBackwardSleepMs() {
        return this.maxBackwardSleepMs;
    }

    public String getTimestampBy() {
        return this.timestampBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Base)) {
            return false;
        }
        Base other = (Base)o;
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getTimestampBits() != other.getTimestampBits()) {
            return false;
        }
        if (this.getRoundMs() != other.getRoundMs()) {
            return false;
        }
        if (this.getBackwardBits() != other.getBackwardBits()) {
            return false;
        }
        if (this.getWorkerBits() != other.getWorkerBits()) {
            return false;
        }
        if (this.getSeqBits() != other.getSeqBits()) {
            return false;
        }
        if (this.getMaxBackwardSleepMs() != other.getMaxBackwardSleepMs()) {
            return false;
        }
        String this$timestampBy = this.getTimestampBy();
        String other$timestampBy = other.getTimestampBy();
        return !(this$timestampBy == null ? other$timestampBy != null : !this$timestampBy.equals(other$timestampBy));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch >>> 32 ^ $epoch);
        result = result * 59 + this.getTimestampBits();
        result = result * 59 + this.getRoundMs();
        result = result * 59 + this.getBackwardBits();
        result = result * 59 + this.getWorkerBits();
        result = result * 59 + this.getSeqBits();
        long $maxBackwardSleepMs = this.getMaxBackwardSleepMs();
        result = result * 59 + (int)($maxBackwardSleepMs >>> 32 ^ $maxBackwardSleepMs);
        String $timestampBy = this.getTimestampBy();
        result = result * 59 + ($timestampBy == null ? 43 : $timestampBy.hashCode());
        return result;
    }

    public String toString() {
        return "Base(epoch=" + this.getEpoch() + ", timestampBits=" + this.getTimestampBits() + ", roundMs=" + this.getRoundMs() + ", backwardBits=" + this.getBackwardBits() + ", workerBits=" + this.getWorkerBits() + ", seqBits=" + this.getSeqBits() + ", maxBackwardSleepMs=" + this.getMaxBackwardSleepMs() + ", timestampBy=" + this.getTimestampBy() + ")";
    }

    public static class BaseBuilder {
        private boolean epoch$set;
        private long epoch$value;
        private boolean timestampBits$set;
        private int timestampBits$value;
        private boolean roundMs$set;
        private int roundMs$value;
        private boolean backwardBits$set;
        private int backwardBits$value;
        private boolean workerBits$set;
        private int workerBits$value;
        private boolean seqBits$set;
        private int seqBits$value;
        private boolean maxBackwardSleepMs$set;
        private long maxBackwardSleepMs$value;
        private boolean timestampBy$set;
        private String timestampBy$value;

        BaseBuilder() {
        }

        public BaseBuilder epoch(long epoch) {
            this.epoch$value = epoch;
            this.epoch$set = true;
            return this;
        }

        public BaseBuilder timestampBits(int timestampBits) {
            this.timestampBits$value = timestampBits;
            this.timestampBits$set = true;
            return this;
        }

        public BaseBuilder roundMs(int roundMs) {
            this.roundMs$value = roundMs;
            this.roundMs$set = true;
            return this;
        }

        public BaseBuilder backwardBits(int backwardBits) {
            this.backwardBits$value = backwardBits;
            this.backwardBits$set = true;
            return this;
        }

        public BaseBuilder workerBits(int workerBits) {
            this.workerBits$value = workerBits;
            this.workerBits$set = true;
            return this;
        }

        public BaseBuilder seqBits(int seqBits) {
            this.seqBits$value = seqBits;
            this.seqBits$set = true;
            return this;
        }

        public BaseBuilder maxBackwardSleepMs(long maxBackwardSleepMs) {
            this.maxBackwardSleepMs$value = maxBackwardSleepMs;
            this.maxBackwardSleepMs$set = true;
            return this;
        }

        public BaseBuilder timestampBy(String timestampBy) {
            this.timestampBy$value = timestampBy;
            this.timestampBy$set = true;
            return this;
        }

        public Base build() {
            long epoch$value = this.epoch$value;
            if (!this.epoch$set) {
                epoch$value = Base.$default$epoch();
            }
            int timestampBits$value = this.timestampBits$value;
            if (!this.timestampBits$set) {
                timestampBits$value = Base.$default$timestampBits();
            }
            int roundMs$value = this.roundMs$value;
            if (!this.roundMs$set) {
                roundMs$value = Base.$default$roundMs();
            }
            int backwardBits$value = this.backwardBits$value;
            if (!this.backwardBits$set) {
                backwardBits$value = Base.$default$backwardBits();
            }
            int workerBits$value = this.workerBits$value;
            if (!this.workerBits$set) {
                workerBits$value = Base.$default$workerBits();
            }
            int seqBits$value = this.seqBits$value;
            if (!this.seqBits$set) {
                seqBits$value = Base.$default$seqBits();
            }
            long maxBackwardSleepMs$value = this.maxBackwardSleepMs$value;
            if (!this.maxBackwardSleepMs$set) {
                maxBackwardSleepMs$value = Base.$default$maxBackwardSleepMs();
            }
            String timestampBy$value = this.timestampBy$value;
            if (!this.timestampBy$set) {
                timestampBy$value = Base.$default$timestampBy();
            }
            return new Base(epoch$value, timestampBits$value, roundMs$value, backwardBits$value, workerBits$value, seqBits$value, maxBackwardSleepMs$value, timestampBy$value);
        }

        public String toString() {
            return "Base.BaseBuilder(epoch$value=" + this.epoch$value + ", timestampBits$value=" + this.timestampBits$value + ", roundMs$value=" + this.roundMs$value + ", backwardBits$value=" + this.backwardBits$value + ", workerBits$value=" + this.workerBits$value + ", seqBits$value=" + this.seqBits$value + ", maxBackwardSleepMs$value=" + this.maxBackwardSleepMs$value + ", timestampBy$value=" + this.timestampBy$value + ")";
        }
    }
}

