/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.conf;

import com.github.gobars.id.conf.Base;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public final class Conf {
    private final long epoch;
    private final int timestampBits;
    private final int roundMs;
    private final int backwardBits;
    private final int workerBits;
    private final int seqBits;
    private final long maxBackwardSleepMs;
    private final TimestampByEnum timestampBy;
    private final long maxSequence;
    private final long maxWorkerId;
    private final long maxBackwardId;
    private final int workerIdShift;
    private final int backwardShift;
    private final int timestampShift;
    private final long maxTimestamp;

    public Conf(Base base) {
        this.epoch = base.getEpoch();
        this.timestampBits = base.getTimestampBits();
        this.roundMs = base.getRoundMs();
        this.backwardBits = base.getBackwardBits();
        this.workerBits = base.getWorkerBits();
        this.seqBits = base.getSeqBits();
        this.maxBackwardSleepMs = base.getMaxBackwardSleepMs();
        this.timestampBy = this.parseTimestampBy(base.getTimestampBy());
        this.maxSequence = -1L << this.seqBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxWorkerId = -1L << this.workerBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxBackwardId = -1L << this.backwardBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxTimestamp = -1L << this.timestampBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.workerIdShift = this.seqBits;
        this.backwardShift = this.workerBits + this.seqBits;
        this.timestampShift = this.backwardBits + this.backwardShift;
    }

    private TimestampByEnum parseTimestampBy(String timestampBy) {
        if ("nano".equals(timestampBy)) {
            return TimestampByEnum.NANO;
        }
        if ("system".equals(timestampBy)) {
            return TimestampByEnum.SYSTEM;
        }
        return TimestampByEnum.CACHE;
    }

    public static Conf fromSpec(String spec) {
        return new Conf(Base.fromSpec(spec));
    }

    public Map<Long, Long> initBackwardIdLastTimesMap() {
        if (this.maxBackwardId <= 0L) {
            return null;
        }
        HashMap<Long, Long> m = new HashMap<Long, Long>((int)this.maxBackwardId);
        for (long i = 0L; i <= this.maxBackwardId; ++i) {
            m.put(i, 0L);
        }
        return m;
    }

    public IDPart parseID(long id) {
        IDPart idPart = new IDPart();
        idPart.id = id;
        idPart.timestamp = (id >> this.getTimestampShift()) + this.getEpoch();
        idPart.backwardId = id >> this.getBackwardShift() & this.getMaxBackwardId();
        idPart.workerID = id >> this.getWorkerIdShift() & this.getMaxWorkerId();
        idPart.sequence = id & this.getMaxSequence();
        return idPart;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public int getTimestampBits() {
        return this.timestampBits;
    }

    public int getRoundMs() {
        return this.roundMs;
    }

    public int getBackwardBits() {
        return this.backwardBits;
    }

    public int getWorkerBits() {
        return this.workerBits;
    }

    public int getSeqBits() {
        return this.seqBits;
    }

    public long getMaxBackwardSleepMs() {
        return this.maxBackwardSleepMs;
    }

    public TimestampByEnum getTimestampBy() {
        return this.timestampBy;
    }

    public long getMaxSequence() {
        return this.maxSequence;
    }

    public long getMaxWorkerId() {
        return this.maxWorkerId;
    }

    public long getMaxBackwardId() {
        return this.maxBackwardId;
    }

    public int getWorkerIdShift() {
        return this.workerIdShift;
    }

    public int getBackwardShift() {
        return this.backwardShift;
    }

    public int getTimestampShift() {
        return this.timestampShift;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conf)) {
            return false;
        }
        Conf other = (Conf)o;
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getTimestampBits() != other.getTimestampBits()) {
            return false;
        }
        if (this.getRoundMs() != other.getRoundMs()) {
            return false;
        }
        if (this.getBackwardBits() != other.getBackwardBits()) {
            return false;
        }
        if (this.getWorkerBits() != other.getWorkerBits()) {
            return false;
        }
        if (this.getSeqBits() != other.getSeqBits()) {
            return false;
        }
        if (this.getMaxBackwardSleepMs() != other.getMaxBackwardSleepMs()) {
            return false;
        }
        TimestampByEnum this$timestampBy = this.getTimestampBy();
        TimestampByEnum other$timestampBy = other.getTimestampBy();
        if (this$timestampBy == null ? other$timestampBy != null : !((Object)((Object)this$timestampBy)).equals((Object)other$timestampBy)) {
            return false;
        }
        if (this.getMaxSequence() != other.getMaxSequence()) {
            return false;
        }
        if (this.getMaxWorkerId() != other.getMaxWorkerId()) {
            return false;
        }
        if (this.getMaxBackwardId() != other.getMaxBackwardId()) {
            return false;
        }
        if (this.getWorkerIdShift() != other.getWorkerIdShift()) {
            return false;
        }
        if (this.getBackwardShift() != other.getBackwardShift()) {
            return false;
        }
        if (this.getTimestampShift() != other.getTimestampShift()) {
            return false;
        }
        return this.getMaxTimestamp() == other.getMaxTimestamp();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epoch = this.getEpoch();
        result = result * 59 + (int)($epoch >>> 32 ^ $epoch);
        result = result * 59 + this.getTimestampBits();
        result = result * 59 + this.getRoundMs();
        result = result * 59 + this.getBackwardBits();
        result = result * 59 + this.getWorkerBits();
        result = result * 59 + this.getSeqBits();
        long $maxBackwardSleepMs = this.getMaxBackwardSleepMs();
        result = result * 59 + (int)($maxBackwardSleepMs >>> 32 ^ $maxBackwardSleepMs);
        TimestampByEnum $timestampBy = this.getTimestampBy();
        result = result * 59 + ($timestampBy == null ? 43 : ((Object)((Object)$timestampBy)).hashCode());
        long $maxSequence = this.getMaxSequence();
        result = result * 59 + (int)($maxSequence >>> 32 ^ $maxSequence);
        long $maxWorkerId = this.getMaxWorkerId();
        result = result * 59 + (int)($maxWorkerId >>> 32 ^ $maxWorkerId);
        long $maxBackwardId = this.getMaxBackwardId();
        result = result * 59 + (int)($maxBackwardId >>> 32 ^ $maxBackwardId);
        result = result * 59 + this.getWorkerIdShift();
        result = result * 59 + this.getBackwardShift();
        result = result * 59 + this.getTimestampShift();
        long $maxTimestamp = this.getMaxTimestamp();
        result = result * 59 + (int)($maxTimestamp >>> 32 ^ $maxTimestamp);
        return result;
    }

    public String toString() {
        return "Conf(epoch=" + this.getEpoch() + ", timestampBits=" + this.getTimestampBits() + ", roundMs=" + this.getRoundMs() + ", backwardBits=" + this.getBackwardBits() + ", workerBits=" + this.getWorkerBits() + ", seqBits=" + this.getSeqBits() + ", maxBackwardSleepMs=" + this.getMaxBackwardSleepMs() + ", timestampBy=" + (Object)((Object)this.getTimestampBy()) + ", maxSequence=" + this.getMaxSequence() + ", maxWorkerId=" + this.getMaxWorkerId() + ", maxBackwardId=" + this.getMaxBackwardId() + ", workerIdShift=" + this.getWorkerIdShift() + ", backwardShift=" + this.getBackwardShift() + ", timestampShift=" + this.getTimestampShift() + ", maxTimestamp=" + this.getMaxTimestamp() + ")";
    }

    public static class IDPart {
        public long id;
        public long timestamp;
        public long backwardId;
        public long workerID;
        public long sequence;

        public String toString() {
            return "IDPart{id=" + this.id + ", timestamp=" + this.timestamp + ", timestampFormat=" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.timestamp) + ", backwardId=" + this.backwardId + ", workerID=" + this.workerID + ", sequence=" + this.sequence + '}';
        }
    }

    public static enum TimestampByEnum {
        NANO,
        SYSTEM,
        CACHE;

    }
}

