/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.OverlappingFileLockException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Files {
    private static final Logger log = LoggerFactory.getLogger(Files.class);
    public static final String GOBARS_ID = System.getProperty("user.home") + File.separator + ".gobars_id";
    public static final String WORKER_ID_PREFIX = "workerID.";
    public static final String processId;

    public static String homeFile(String filename) {
        return GOBARS_ID + File.separator + filename;
    }

    public static int findAvailableWorkerID(int workerID, boolean allowOverlapping) {
        if (Files.lockWorkerID(workerID, allowOverlapping)) {
            return workerID;
        }
        int incr = workerID % 100;
        int i = workerID + incr;
        int j = 0;
        while (j < 1024) {
            if (Files.lockWorkerID(i, allowOverlapping)) {
                return i;
            }
            i += incr;
        }
        return -1;
    }

    public static int tryAvailableLocalWorker(boolean allowOverlapping) {
        File[] files = new File(GOBARS_ID).listFiles();
        if (files == null) {
            return -1;
        }
        for (File file : files) {
            String fn;
            if (file.isDirectory() || !(fn = file.getName()).startsWith(WORKER_ID_PREFIX)) continue;
            String workerId = fn.substring(WORKER_ID_PREFIX.length());
            try {
                int i = Integer.parseInt(workerId);
                if (!Files.lockWorkerID(i, allowOverlapping)) continue;
                return i;
            }
            catch (Exception ignore) {
                log.warn("bad worker id {}", (Object)workerId);
            }
        }
        return -1;
    }

    public static boolean lockWorkerID(int workerID, boolean allowOverlapping) {
        return Files.tryLockFile(Files.homeFile(WORKER_ID_PREFIX + workerID), allowOverlapping);
    }

    public static boolean tryLockFile(String filename, boolean allowOverlapping) {
        try {
            RandomAccessFile f = new RandomAccessFile(filename, "rw");
            if (f.getChannel().tryLock() == null) {
                return false;
            }
            f.writeBytes(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
            f.writeBytes(" pid=");
            f.writeBytes(processId);
            return true;
        }
        catch (OverlappingFileLockException e) {
            return allowOverlapping;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filePath) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(filePath));
        try {
            long len = new File(filePath).length();
            if (len > Integer.MAX_VALUE) {
                throw new IOException("File " + filePath + " too large, was " + len + " bytes.");
            }
            byte[] bytes = new byte[(int)len];
            dis.readFully(bytes);
            String string = new String(bytes, "UTF-8");
            return string;
        }
        finally {
            if (Collections.singletonList(dis).get(0) != null) {
                dis.close();
            }
        }
    }

    public static void saveFile(String filename, String value) {
        try {
            PrintWriter out = new PrintWriter(filename);
            try {
                out.print(value);
            }
            finally {
                if (Collections.singletonList(out).get(0) != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            log.warn("failed to write {}", (Object)filename, (Object)e);
        }
    }

    private Files() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        File dir = new File(GOBARS_ID);
        dir.mkdirs();
        if (!dir.exists()) {
            throw new RuntimeException("create dirs ~/.gobarsid failed");
        }
        processId = Files.getProcessId("0");
    }
}

