/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class Ip {
    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        InetAddress candidateAddress = null;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                Enumeration<InetAddress> inetAddrs = ifaces.nextElement().getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("InetAddress.getLocalHost() unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException ex = new UnknownHostException("Failed to determine LAN address: " + e);
            ex.initCause(e);
            throw ex;
        }
    }

    private Ip() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

