/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SystemClock {
    private final long period;
    private final AtomicLong now;
    private final ExecutorService scheduler;

    private SystemClock(long period) {
        this.period = period;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduler = this.scheduleClockUpdating();
    }

    public static long now() {
        return SystemClock.instance().currentTimeMillis();
    }

    private static SystemClock instance() {
        return InstanceHolder.INSTANCE;
    }

    private ExecutorService scheduleClockUpdating() {
        ScheduledExecutorService s = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "System Clock");
                t.setDaemon(true);
                return t;
            }
        });
        Runnable sr = new Runnable(){

            @Override
            public void run() {
                SystemClock.this.now.set(System.currentTimeMillis());
            }
        };
        s.scheduleAtFixedRate(sr, this.period, this.period, TimeUnit.MILLISECONDS);
        Runnable dr = new Runnable(){

            @Override
            public void run() {
                SystemClock.this.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(dr));
        return s;
    }

    public void destroy() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    private long currentTimeMillis() {
        return this.now.get();
    }

    private static class InstanceHolder {
        public static final SystemClock INSTANCE = new SystemClock(1L);

        private InstanceHolder() {
        }
    }
}

