/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.worker;

import com.github.gobars.id.WorkerId;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerIdHostname
implements WorkerId {
    private static final Logger log = LoggerFactory.getLogger(WorkerIdHostname.class);
    public static final String HOSTNAME = WorkerIdHostname.getHostname();
    private static final Pattern HOSTNAME_WORKER_ID_PATTERN = Pattern.compile("\\d+$");
    private static final int WORKER_ID = WorkerIdHostname.parseWorkerId(HOSTNAME);

    public static int parseWorkerId(String hostname) {
        Matcher m = HOSTNAME_WORKER_ID_PATTERN.matcher(hostname);
        if (m.find()) {
            return Integer.parseInt(m.group());
        }
        return 0;
    }

    public static String getHostname() {
        String host = System.getenv("COMPUTERNAME");
        if (host != null) {
            log.info("got hostname {} from env COMPUTERNAME", (Object)host);
            return host;
        }
        host = System.getenv("HOSTNAME");
        if (host != null) {
            log.info("got hostname {} from env HOSTNAME", (Object)host);
            return host;
        }
        try {
            InputStream is = Runtime.getRuntime().exec("hostname").getInputStream();
            String s = new BufferedReader(new InputStreamReader(is)).readLine();
            log.info("got hostname {} from exec hostname", (Object)s);
            return s;
        }
        catch (Exception ex) {
            log.warn("exec hostname", (Throwable)ex);
            return "Unknown";
        }
    }

    @Override
    public int workerId() {
        return WORKER_ID;
    }
}

