/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.worker;

import com.github.gobars.id.WorkerId;
import com.github.gobars.id.util.Ip;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerIdIp
implements WorkerId {
    private static final Logger log = LoggerFactory.getLogger(WorkerIdIp.class);
    private static final IdIp ID_IP = WorkerIdIp.init();
    public static final String LOCAL_IP = ID_IP.getLocalIp();
    public static final int WORKER_ID = ID_IP.getWorkerId();

    private static IdIp init() {
        try {
            InetAddress addr = Ip.getLocalHostLANAddress();
            String localIP = addr.getHostAddress();
            byte[] bytes = addr.getAddress();
            int workerId = bytes[bytes.length - 1] & 0xFF;
            return new IdIp(workerId, localIP);
        }
        catch (Exception ex) {
            log.warn("failed to determine LAN address", (Throwable)ex);
            return new IdIp(0, "unknown");
        }
    }

    @Override
    public int workerId() {
        return WORKER_ID;
    }

    static final class IdIp {
        private final int workerId;
        private final String localIp;

        public IdIp(int workerId, String localIp) {
            this.workerId = workerId;
            this.localIp = localIp;
        }

        public int getWorkerId() {
            return this.workerId;
        }

        public String getLocalIp() {
            return this.localIp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdIp)) {
                return false;
            }
            IdIp other = (IdIp)o;
            if (this.getWorkerId() != other.getWorkerId()) {
                return false;
            }
            String this$localIp = this.getLocalIp();
            String other$localIp = other.getLocalIp();
            return !(this$localIp == null ? other$localIp != null : !this$localIp.equals(other$localIp));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWorkerId();
            String $localIp = this.getLocalIp();
            result = result * 59 + ($localIp == null ? 43 : $localIp.hashCode());
            return result;
        }

        public String toString() {
            return "WorkerIdIp.IdIp(workerId=" + this.getWorkerId() + ", localIp=" + this.getLocalIp() + ")";
        }
    }
}

