/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id;

import com.github.gobars.id.IdNext;
import com.github.gobars.id.conf.Conf;
import com.github.gobars.id.util.SystemClock;
import com.github.gobars.id.util.Util;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snowflake
implements IdNext {
    private static final Logger log = LoggerFactory.getLogger(Snowflake.class);
    private final Conf conf;
    private final Map<Long, Long> backwardIdLastTimes;
    protected long workerId;
    protected long lastTs;
    protected long sequence;
    private long backwardId;

    public Snowflake(Conf conf, long workerId) {
        this.conf = conf;
        this.workerId = workerId & conf.getMaxWorkerId();
        this.backwardId = Util.readBackwardId(workerId);
        this.backwardIdLastTimes = conf.initBackwardIdLastTimesMap();
        log.debug("Snowflake created from conf {} with workerId {}", (Object)conf, (Object)workerId);
    }

    @Override
    public synchronized long next() {
        long cur = this.timeBackDeal();
        if (this.lastTs == cur) {
            ++this.sequence;
            this.sequence &= this.conf.getMaxSequence();
            if (this.sequence == 0L) {
                cur = this.lastTs + 1L;
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTs = cur;
        if (this.backwardIdLastTimes != null) {
            this.backwardIdLastTimes.put(this.backwardId, this.lastTs);
        }
        return (cur - this.conf.getEpoch() & this.conf.getMaxTimestamp()) << this.conf.getTimestampShift() | this.backwardId << this.conf.getBackwardShift() | this.workerId << this.conf.getWorkerIdShift() | this.sequence;
    }

    private long timeBackDeal() {
        long cur = this.currentTimeMillis() / (long)this.conf.getRoundMs();
        if (cur >= this.lastTs) {
            return cur;
        }
        long diff = (this.lastTs - cur) * (long)this.conf.getRoundMs();
        if (diff <= this.conf.getMaxBackwardSleepMs()) {
            Util.sleep(diff + 10L);
            cur = this.currentTimeMillis() / (long)this.conf.getRoundMs();
        }
        if (cur < this.lastTs) {
            this.rotateBackwardId(cur);
        }
        return cur;
    }

    protected void rotateBackwardId(long cur) {
        if (this.backwardIdLastTimes != null) {
            for (Map.Entry<Long, Long> e : this.backwardIdLastTimes.entrySet()) {
                if (e.getValue() > cur || e.getKey() == this.backwardId) continue;
                log.info("rotate backward Id from {} to {}", (Object)this.backwardId, (Object)e.getKey());
                this.backwardId = e.getKey();
                Util.saveBackwardId(this.workerId, this.backwardId);
                return;
            }
        }
        throw new IllegalStateException("Clock is moving backwards, current time is " + cur * (long)this.conf.getRoundMs() + " mills, workerId map = " + this.backwardIdLastTimes);
    }

    protected long currentTimeMillis() {
        switch (this.conf.getTimestampBy()) {
            case SYSTEM: {
                return System.currentTimeMillis();
            }
            case NANO: {
                return System.nanoTime();
            }
        }
        return SystemClock.now();
    }
}

