/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.conf;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public interface ConnGetter {
    public Connection getConn() throws SQLException;

    public static final class JdbcConnGetter
    implements ConnGetter {
        private final String url;
        private final String user;
        private final String password;

        @Override
        public Connection getConn() throws SQLException {
            return DriverManager.getConnection(this.url, this.user, this.password);
        }

        public JdbcConnGetter(String url, String user, String password) {
            this.url = url;
            this.user = user;
            this.password = password;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JdbcConnGetter)) {
                return false;
            }
            JdbcConnGetter other = (JdbcConnGetter)o;
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "ConnGetter.JdbcConnGetter(url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ")";
        }
    }

    public static final class DsConnGetter
    implements ConnGetter {
        private final DataSource dataSource;

        @Override
        public Connection getConn() throws SQLException {
            return this.dataSource.getConnection();
        }

        public DsConnGetter(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DsConnGetter)) {
                return false;
            }
            DsConnGetter other = (DsConnGetter)o;
            DataSource this$dataSource = this.getDataSource();
            DataSource other$dataSource = other.getDataSource();
            return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DataSource $dataSource = this.getDataSource();
            result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
            return result;
        }

        public String toString() {
            return "ConnGetter.DsConnGetter(dataSource=" + this.getDataSource() + ")";
        }
    }
}

