/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.db;

import com.github.gobars.id.conf.Conf;
import com.github.gobars.id.conf.ConnGetter;
import com.github.gobars.id.db.SnowflakeDb;
import com.github.gobars.id.db.WorkerIdDb;
import javax.sql.DataSource;

public final class DbId {
    private static SnowflakeDb next;

    public static void configure(DataSource ds) {
        DbId.configure(new WorkerIdDb().connGetter(new ConnGetter.DsConnGetter(ds)).biz("default"));
    }

    public static void configure(String url, String user, String password) {
        ConnGetter.JdbcConnGetter ds = new ConnGetter.JdbcConnGetter(url, user, password);
        DbId.configure(new WorkerIdDb().connGetter(ds).biz("default"));
    }

    public static void configure(WorkerIdDb workerIdDb) {
        next = new SnowflakeDb(Conf.fromSpec("epoch=20200603,timestampBits=41,backwardBits=2,workerBits=8,seqBits=12,roundMs=1,maxBackwardSleepMs=1000"), workerIdDb);
    }

    public static long next() {
        return next.next();
    }

    private DbId() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        DbId.configure("jdbc:mysql://localhost:3306/id?useSSL=false", "root", "root");
    }
}

