/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.db;

import com.github.gobars.id.IdNext;
import com.github.gobars.id.conf.ConnGetter;
import com.github.gobars.id.db.SqlRunner;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;

public class Seq
implements IdNext {
    private final Object LOCK = new Object();
    private static final int START_SEQ = 10000;
    private ConnGetter connGetter;
    private String name = "default";
    private String table = "t_seq";
    private int waterLevel;
    private int step;
    private long maxSeq;
    private boolean cycle;
    private long seq1;
    private long seq2;
    private int curr;
    private int avail1;
    private int avail2;
    private boolean updating;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.maxSeq > 0L && (this.seq1 > this.maxSeq || this.seq2 > this.maxSeq)) {
                throw new OverMaxSeqException();
            }
            long v = 0L;
            long avail = 0L;
            for (int retries = 0; retries < 2; ++retries) {
                if (this.avail1 <= 0 && this.avail2 <= 0) {
                    this.triggerUpdate(false);
                }
                if (this.curr == 0) {
                    this.curr = this.avail1 > 0 ? 1 : 2;
                } else if (this.curr == 1 && this.avail1 <= 0) {
                    this.curr = 2;
                } else if (this.curr == 2 && this.avail2 <= 0) {
                    this.curr = 1;
                }
                if (this.curr == 1) {
                    v = this.seq1++;
                    avail = --this.avail1;
                } else {
                    v = this.seq2++;
                    avail = --this.avail2;
                }
                if (this.maxSeq <= 0L || v < this.maxSeq) break;
                if (!this.cycle) {
                    throw new OverMaxSeqException();
                }
                this.resetState();
                this.resetDb();
            }
            if (avail <= (long)this.waterLevel) {
                this.triggerUpdate(true);
            }
            return v;
        }
    }

    private void resetState() {
        this.curr = 1;
        this.seq1 = 0L;
        this.avail1 = 0;
        this.seq2 = 0L;
        this.avail2 = 0;
    }

    private void triggerUpdate(boolean async) {
        if (this.avail1 > 0 && this.avail2 > 0) {
            return;
        }
        if (!async) {
            this.updateSeq();
            return;
        }
        if (this.updating) {
            this.updateSeq();
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Seq.this.updateSeqLock();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSeqLock() {
        Object object = this.LOCK;
        synchronized (object) {
            this.updateSeq();
            this.updating = false;
        }
    }

    private void updateSeq() {
        if (this.avail1 > 0 && this.avail2 > 0) {
            return;
        }
        DbSeq ds = this.updateDb();
        this.waterLevel = ds.waterLevel;
        this.maxSeq = ds.maxSeq;
        this.cycle = ds.cycle;
        if (this.avail1 <= 0) {
            this.seq1 = ds.seq - (long)ds.step;
            this.avail1 = ds.step;
        } else if (this.avail2 <= 0) {
            this.seq2 = ds.seq - (long)ds.step;
            this.avail2 = ds.step;
        }
    }

    public void resetDb() {
        Connection c = this.connGetter.getConn();
        try {
            c.setAutoCommit(true);
            SqlRunner r = new SqlRunner(c);
            r.update("update " + this.table + " set seq = start where name = ?", this.name);
        }
        finally {
            if (Collections.singletonList(c).get(0) != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public DbSeq updateDb() {
        Connection c = this.connGetter.getConn();
        try {
            DbSeq dbSeq;
            String s;
            String u;
            SqlRunner r;
            block13: {
                DbSeq dbSeq2;
                c.setAutoCommit(false);
                r = new SqlRunner(c);
                u = "update " + this.table + " set seq = seq + step where name = ?";
                s = "select seq, step, water_level, max_seq, cycle from " + this.table + " where name = ?";
                try {
                    int row = r.update(u, this.name);
                    dbSeq = new DbSeq();
                    if (row <= 0) break block13;
                    r.select(1, dbSeq, s, this.name);
                    dbSeq2 = dbSeq;
                }
                catch (Throwable throwable) {
                    c.commit();
                    throw throwable;
                }
                c.commit();
                return dbSeq2;
            }
            try {
                String i = "insert " + this.table + "(name) values(?)";
                r.insert(i, this.name);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            r.update(u, this.name);
            r.select(1, dbSeq, s, this.name);
            DbSeq dbSeq3 = dbSeq;
            c.commit();
            return dbSeq3;
        }
        finally {
            if (Collections.singletonList(c).get(0) != null) {
                c.close();
            }
        }
    }

    public Object getLOCK() {
        return this.LOCK;
    }

    public ConnGetter connGetter() {
        return this.connGetter;
    }

    public String name() {
        return this.name;
    }

    public String table() {
        return this.table;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public int getStep() {
        return this.step;
    }

    public long getMaxSeq() {
        return this.maxSeq;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public long getSeq1() {
        return this.seq1;
    }

    public long getSeq2() {
        return this.seq2;
    }

    public int getCurr() {
        return this.curr;
    }

    public int getAvail1() {
        return this.avail1;
    }

    public int getAvail2() {
        return this.avail2;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public Seq connGetter(ConnGetter connGetter) {
        this.connGetter = connGetter;
        return this;
    }

    public Seq name(String name) {
        this.name = name;
        return this;
    }

    public Seq table(String table) {
        this.table = table;
        return this;
    }

    public void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public void setMaxSeq(long maxSeq) {
        this.maxSeq = maxSeq;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    public void setSeq1(long seq1) {
        this.seq1 = seq1;
    }

    public void setSeq2(long seq2) {
        this.seq2 = seq2;
    }

    public void setCurr(int curr) {
        this.curr = curr;
    }

    public void setAvail1(int avail1) {
        this.avail1 = avail1;
    }

    public void setAvail2(int avail2) {
        this.avail2 = avail2;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Seq)) {
            return false;
        }
        Seq other = (Seq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$LOCK = this.getLOCK();
        Object other$LOCK = other.getLOCK();
        if (this$LOCK == null ? other$LOCK != null : !this$LOCK.equals(other$LOCK)) {
            return false;
        }
        ConnGetter this$connGetter = this.connGetter();
        ConnGetter other$connGetter = other.connGetter();
        if (this$connGetter == null ? other$connGetter != null : !this$connGetter.equals(other$connGetter)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$table = this.table();
        String other$table = other.table();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        if (this.getWaterLevel() != other.getWaterLevel()) {
            return false;
        }
        if (this.getStep() != other.getStep()) {
            return false;
        }
        if (this.getMaxSeq() != other.getMaxSeq()) {
            return false;
        }
        if (this.isCycle() != other.isCycle()) {
            return false;
        }
        if (this.getSeq1() != other.getSeq1()) {
            return false;
        }
        if (this.getSeq2() != other.getSeq2()) {
            return false;
        }
        if (this.getCurr() != other.getCurr()) {
            return false;
        }
        if (this.getAvail1() != other.getAvail1()) {
            return false;
        }
        if (this.getAvail2() != other.getAvail2()) {
            return false;
        }
        return this.isUpdating() == other.isUpdating();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Seq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $LOCK = this.getLOCK();
        result = result * 59 + ($LOCK == null ? 43 : $LOCK.hashCode());
        ConnGetter $connGetter = this.connGetter();
        result = result * 59 + ($connGetter == null ? 43 : $connGetter.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $table = this.table();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        result = result * 59 + this.getWaterLevel();
        result = result * 59 + this.getStep();
        long $maxSeq = this.getMaxSeq();
        result = result * 59 + (int)($maxSeq >>> 32 ^ $maxSeq);
        result = result * 59 + (this.isCycle() ? 79 : 97);
        long $seq1 = this.getSeq1();
        result = result * 59 + (int)($seq1 >>> 32 ^ $seq1);
        long $seq2 = this.getSeq2();
        result = result * 59 + (int)($seq2 >>> 32 ^ $seq2);
        result = result * 59 + this.getCurr();
        result = result * 59 + this.getAvail1();
        result = result * 59 + this.getAvail2();
        result = result * 59 + (this.isUpdating() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Seq(LOCK=" + this.getLOCK() + ", connGetter=" + this.connGetter() + ", name=" + this.name() + ", table=" + this.table() + ", waterLevel=" + this.getWaterLevel() + ", step=" + this.getStep() + ", maxSeq=" + this.getMaxSeq() + ", cycle=" + this.isCycle() + ", seq1=" + this.getSeq1() + ", seq2=" + this.getSeq2() + ", curr=" + this.getCurr() + ", avail1=" + this.getAvail1() + ", avail2=" + this.getAvail2() + ", updating=" + this.isUpdating() + ")";
    }

    public static class OverMaxSeqException
    extends RuntimeException {
    }

    private static class DbSeq
    implements SqlRunner.RowScanner {
        long seq;
        int step;
        int waterLevel;
        long maxSeq;
        boolean cycle;

        private DbSeq() {
        }

        @Override
        public boolean scanRow(int rowIndex, ResultSet rs) throws SQLException {
            this.seq = rs.getLong(1);
            this.step = rs.getInt(2);
            this.waterLevel = rs.getInt(3);
            this.maxSeq = rs.getLong(4);
            this.cycle = rs.getBoolean(5);
            return false;
        }
    }
}

