/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.db;

import com.github.gobars.id.util.DbType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SqlRunner {
    public static final int NO_GENERATED_KEY = -2147482647;
    Connection cnn;
    boolean useGeneratedKeySupport;

    public SqlRunner(Connection cnn) {
        this(cnn, false);
    }

    public SqlRunner(Connection cnn, boolean useGeneratedKeySupport) {
        this.cnn = cnn;
        this.useGeneratedKeySupport = useGeneratedKeySupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> selectOne(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.cnn.prepareStatement(sql);
        try {
            Map<String, String> map;
            block9: {
                this.setParameters(ps, args);
                ResultSet rs = ps.executeQuery();
                try {
                    List<Map<String, String>> results = this.getResults(rs, 1);
                    if (results.size() != 1) {
                        throw new SQLException("Statement returned more results where exactly one (1) was expected.");
                    }
                    map = results.get(0);
                    if (Collections.singletonList(rs).get(0) == null) break block9;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            return map;
        }
        finally {
            if (Collections.singletonList(ps).get(0) != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long selectLong(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.cnn.prepareStatement(sql);
        try {
            long l;
            block8: {
                this.setParameters(ps, args);
                ResultSet rs = ps.executeQuery();
                try {
                    l = this.getLong(rs);
                    if (Collections.singletonList(rs).get(0) == null) break block8;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
        finally {
            if (Collections.singletonList(ps).get(0) != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(int limit, RowScanner scanner, String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.cnn.prepareStatement(sql);
        try {
            this.setParameters(ps, args);
            ResultSet rs = ps.executeQuery();
            try {
                this.getObjects(rs, limit, scanner);
            }
            finally {
                if (Collections.singletonList(rs).get(0) != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(ps).get(0) != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> selectAll(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.cnn.prepareStatement(sql);
        try {
            List<Map<String, String>> list;
            block8: {
                this.setParameters(ps, args);
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getResults(rs, -1);
                    if (Collections.singletonList(rs).get(0) == null) break block8;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        finally {
            if (Collections.singletonList(ps).get(0) != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.prepareStatement(this.cnn, sql);
        try {
            this.setParameters(ps, args);
            ps.executeUpdate();
            if (this.useGeneratedKeySupport) {
                int n = this.parseGeneratedKey(ps);
                return n;
            }
            int n = -2147482647;
            return n;
        }
        finally {
            if (Collections.singletonList(ps).get(0) != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.prepareStatement(this.cnn, sql);
        try {
            this.setParameters(ps, args);
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            if (Collections.singletonList(ps).get(0) != null) {
                ps.close();
            }
        }
    }

    private PreparedStatement prepareStatement(Connection cnn, String sql) throws SQLException {
        if (!this.useGeneratedKeySupport) {
            return cnn.prepareStatement(sql);
        }
        switch (DbType.getDbType(cnn)) {
            case MYSQL: {
                return cnn.prepareStatement(sql, 1);
            }
            case ORACLE: {
                return cnn.prepareStatement(sql, new int[]{1});
            }
        }
        throw new SQLException("unsupported db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parseGeneratedKey(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.getGeneratedKeys();
        try {
            List<Map<String, String>> keys = this.getResults(rs, 1);
            if (keys.isEmpty()) {
                int n = -1;
                return n;
            }
            Iterator<String> i = keys.get(0).values().iterator();
            if (!i.hasNext()) {
                int n = -1;
                return n;
            }
            String genkey = i.next();
            if (genkey == null) {
                int n = -1;
                return n;
            }
            int n = Integer.parseInt(genkey);
            return n;
        }
        finally {
            if (Collections.singletonList(rs).get(0) != null) {
                rs.close();
            }
        }
    }

    private void setParameters(PreparedStatement ps, Object ... args) throws SQLException {
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            ps.setObject(i + 1, args[i]);
        }
    }

    public List<Map<String, String>> getResults(ResultSet rs, int limit) throws SQLException {
        ArrayList<String> cols = new ArrayList<String>(10);
        ResultSetMetaData md = rs.getMetaData();
        int n = md.getColumnCount();
        for (int i = 0; i < n; ++i) {
            cols.add(md.getColumnLabel(i + 1));
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int rows = 0; rs.next() && (limit <= 0 || rows < limit); ++rows) {
            HashMap<String, String> row = new HashMap<String, String>();
            int n2 = cols.size();
            for (int i = 0; i < n2; ++i) {
                String name = ((String)cols.get(i)).toLowerCase(Locale.ENGLISH);
                String value = rs.getString(i + 1);
                row.put(name, value);
            }
            list.add(row);
        }
        return list;
    }

    public long getLong(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return rs.getLong(1);
        }
        throw new NoRowsFoundException();
    }

    public void getObjects(ResultSet rs, int limit, RowScanner scanner) throws SQLException {
        for (int i = 0; rs.next() && (limit <= 0 || i < limit) && scanner.scanRow(i, rs); ++i) {
        }
    }

    public static class NoRowsFoundException
    extends SQLException {
    }

    public static interface RowScanner {
        public boolean scanRow(int var1, ResultSet var2) throws SQLException;
    }
}

