/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Collections;
import javax.sql.DataSource;

public enum DbType {
    ORACLE,
    MYSQL,
    UNKNOWN;


    public static DbType getDbType(DataSource dataSource) {
        DbType dbType;
        block6: {
            Connection conn = dataSource.getConnection();
            try {
                dbType = DbType.getDbType(conn);
                if (Collections.singletonList(conn).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
                throw throwable;
            }
            conn.close();
        }
        return dbType;
    }

    public static DbType getDbType(Connection conn) {
        DatabaseMetaData metaData = conn.getMetaData();
        String driverName = metaData.getDriverName().toUpperCase();
        if (driverName.contains("MYSQL")) {
            return MYSQL;
        }
        if (driverName.contains("ORACLE")) {
            return ORACLE;
        }
        return UNKNOWN;
    }
}

