/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.util;

import com.github.gobars.id.util.Util;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pid {
    private static final Logger log = LoggerFactory.getLogger(Pid.class);
    public static final int PROCESS_ID = Pid.getProcessId(0);

    private static int getProcessId(int fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Integer.parseInt(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static boolean isStillAlive(int pid) {
        String command;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            log.debug("Check alive Windows mode. Pid: [{}]", (Object)pid);
            command = "cmd /c tasklist /FI \"PID eq " + pid + "\"";
        } else if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
            log.debug("Check alive Linux/Unix mode. Pid: [{}]", (Object)pid);
            command = "ps -p " + pid;
        } else {
            log.warn("Unsupported OS: Check alive for Pid: [{}] return false", (Object)pid);
            return false;
        }
        return Pid.isProcessIdRunning(pid, command);
    }

    private static boolean isProcessIdRunning(int pid, String command) {
        log.debug("exec command {}", (Object)command);
        String result = Util.exec(command);
        return result.contains(" " + pid + " ");
    }

    private Pid() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

