/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.util;

import com.github.gobars.id.util.Files;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveBackwardId(long workerId, long backwardId) {
        Files.saveFile(Util.backwardIdFile(workerId), String.valueOf(backwardId));
    }

    public static long readBackwardId(long workerId) {
        String file = Util.backwardIdFile(workerId);
        try {
            return Long.parseLong(Files.readFile(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            log.warn("failed to read {}", (Object)file, (Object)e);
        }
        return 0L;
    }

    public static String backwardIdFile(long workerId) {
        return Files.homeFile(".worker.backwardId." + workerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static String exec(String execCommand) {
        Process proc = Runtime.getRuntime().exec(execCommand);
        InputStream stream = proc.getInputStream();
        try {
            Scanner scanner = new Scanner(stream).useDelimiter("\\A");
            try {
                String string;
                String string2 = string = scanner.hasNext() ? scanner.next() : "";
                if (Collections.singletonList(scanner).get(0) != null) {
                    scanner.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(scanner).get(0) != null) {
                    scanner.close();
                }
                throw throwable;
            }
        }
        finally {
            if (Collections.singletonList(stream).get(0) != null) {
                stream.close();
            }
        }
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

