/*
 * Decompiled with CFR 0.152.
 */
package com.github.gobars.id.worker;

import com.github.gobars.id.WorkerId;
import com.github.gobars.id.util.Files;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerIdComposite
implements WorkerId {
    private static final Logger log = LoggerFactory.getLogger(WorkerIdComposite.class);
    private final List<WorkerId> workerIds;

    public WorkerIdComposite(List<WorkerId> workerIds) {
        this.workerIds = workerIds;
    }

    public WorkerIdComposite(WorkerId ... workerIds) {
        this(Arrays.asList(workerIds));
    }

    @Override
    public int workerId() {
        for (WorkerId workerId : this.workerIds) {
            int v = workerId.workerId();
            if (v > 0) {
                log.info("a worker id {} generated by {}, check its availability", (Object)v, workerId.getClass());
                v = Files.findAvailableWorkerID(v, true);
            }
            if (v <= 0) continue;
            log.info("a worker id {} generated by {}", (Object)v, workerId.getClass());
            return v;
        }
        return 0;
    }
}

