/*
 * Decompiled with CFR 0.152.
 */
package com.github.goblinbr.bchscanner;

import com.github.goblinbr.bchscanner.call.CallHierarchy;
import com.github.goblinbr.bchscanner.call.JavaMethod;
import com.github.goblinbr.bchscanner.visitors.CallerClassVisitor;
import com.github.goblinbr.bchscanner.visitors.SuperClassVisitor;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScanner
implements Closeable {
    private JarFile jarFile;

    public JavaScanner(String jarPath) throws IOException {
        this.jarFile = new JarFile(jarPath);
    }

    public Set<JavaMethod> findCallersOfAnyMethod(String className) throws IOException {
        return this.findCallersOfMethod(className, null);
    }

    public Set<JavaMethod> findCallersOfMethod(String className, String methodSignature) throws IOException {
        String methodName = "";
        String methodDesc = "";
        if (methodSignature != null) {
            Method method = Method.getMethod((String)methodSignature);
            methodName = method.getName();
            methodDesc = method.getDescriptor();
        }
        return this.findCallersOfMethod(className, methodName, methodDesc);
    }

    private Set<JavaMethod> findCallersOfMethod(String className, String methodName, String methodDesc) throws IOException {
        Set<String> classNames = this.findAllClassesThatExtendsOrImplements(className);
        CallerClassVisitor callerClassVisitor = new CallerClassVisitor(classNames, methodName, methodDesc);
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            BufferedInputStream stream = new BufferedInputStream(this.jarFile.getInputStream(entry), 1024);
            ClassReader reader = new ClassReader((InputStream)stream);
            reader.accept((ClassVisitor)callerClassVisitor, 0);
            ((InputStream)stream).close();
        }
        return callerClassVisitor.getCallers();
    }

    public CallHierarchy findCallHierarchy(String className, String methodSignature) throws IOException {
        String methodName = "";
        String methodDesc = "";
        if (methodSignature != null) {
            Method method = Method.getMethod((String)methodSignature);
            methodName = method.getName();
            methodDesc = method.getDescriptor();
        }
        CallHierarchy callHierarchy = new CallHierarchy(null, className, methodName, methodDesc);
        this.findCallHierarchy(callHierarchy);
        return callHierarchy;
    }

    private void findCallHierarchy(CallHierarchy callHierarchy) throws IOException {
        JavaMethod method = callHierarchy.getMethod();
        Set<JavaMethod> callers = this.findCallersOfMethod(method.getClassName(), method.getMethodName(), method.getMethodDesc());
        for (JavaMethod javaMethod : callers) {
            if (callHierarchy.containsCall(javaMethod)) continue;
            CallHierarchy callHierarchyCaller = new CallHierarchy(callHierarchy, javaMethod.getClassName(), javaMethod.getMethodName(), javaMethod.getMethodDesc());
            callHierarchy.addCaller(callHierarchyCaller);
        }
        for (CallHierarchy callHierarchy2 : callHierarchy.getCallers()) {
            this.findCallHierarchy(callHierarchy2);
        }
    }

    public CallHierarchy findCallHierarchyOfAnyMethod(String className) throws IOException {
        return this.findCallHierarchy(className, null);
    }

    public Set<String> findAllClassesThatExtendsOrImplements(String className) throws IOException {
        int qtyClass;
        SuperClassVisitor superClassVisitor = new SuperClassVisitor(className);
        do {
            qtyClass = superClassVisitor.getClassNames().size();
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                BufferedInputStream stream = new BufferedInputStream(this.jarFile.getInputStream(entry), 1024);
                ClassReader reader = new ClassReader((InputStream)stream);
                reader.accept((ClassVisitor)superClassVisitor, 0);
                ((InputStream)stream).close();
            }
        } while (qtyClass != superClassVisitor.getClassNames().size());
        return superClassVisitor.getClassNames();
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }
}

