/*
 * Decompiled with CFR 0.152.
 */
package com.github.goblinbr.bchscanner.call;

import com.github.goblinbr.bchscanner.call.JavaMethod;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallHierarchy
implements Comparable<CallHierarchy> {
    private JavaMethod method;
    private CallHierarchy callee;
    private List<CallHierarchy> callers;

    public CallHierarchy(CallHierarchy callee, String className, String methodName, String methodDesc) {
        this.callee = callee;
        this.method = new JavaMethod(className, methodName, methodDesc);
        this.callers = new ArrayList<CallHierarchy>();
    }

    public void addCaller(CallHierarchy caller) {
        this.callers.add(caller);
    }

    public CallHierarchy getCallee() {
        return this.callee;
    }

    public List<CallHierarchy> getCallers() {
        return this.callers;
    }

    public JavaMethod getMethod() {
        return this.method;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == CallHierarchy.class && obj.hashCode() == this.hashCode();
    }

    @Override
    public int compareTo(CallHierarchy o) {
        return this.method.compareTo(o.method);
    }

    public String toString() {
        String spaces = "";
        for (CallHierarchy c = this.callee; c != null; c = c.getCallee()) {
            spaces = spaces + " ";
        }
        return spaces + this.method.toString();
    }

    public boolean containsCall(JavaMethod method) {
        boolean contains = this.method.equals(method);
        if (!contains && this.callee != null) {
            contains = this.callee.containsCall(method);
        }
        return contains;
    }
}

