/*
 * Decompiled with CFR 0.152.
 */
package com.github.goblinbr.bchscanner.call;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod
implements Comparable<JavaMethod> {
    private String className;
    private String methodName;
    private String methodDesc;

    public JavaMethod(String className, String methodName, String methodDesc) {
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSimpleClassName() {
        String simpleName = this.className;
        int index = this.className.lastIndexOf("/");
        if (index >= 0) {
            simpleName = this.className.substring(index + 1);
        }
        return simpleName;
    }

    public String getPackageName() {
        String packageName = "";
        int index = this.className.lastIndexOf("/");
        if (index >= 0) {
            packageName = this.className.substring(0, index).replace("/", ".");
        }
        return packageName;
    }

    public int hashCode() {
        return (this.className + this.methodName + this.methodDesc).hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == JavaMethod.class && obj.hashCode() == this.hashCode();
    }

    @Override
    public int compareTo(JavaMethod o) {
        int comp = this.className.compareTo(o.className);
        if (comp == 0 && (comp = this.methodName.compareTo(o.methodName)) == 0) {
            comp = this.methodDesc.compareTo(o.methodDesc);
        }
        return comp;
    }

    public String toString() {
        return this.className + (this.methodName.equals("") ? "" : "." + this.methodName + this.methodDesc);
    }
}

